/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.errors.SoInternalError;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class ElementManager {
    private static Hashtable<Class<? extends SoElement>, Integer> s_classStackIndex = new Hashtable();
    private static Hashtable<Class<? extends SoElement>, Integer> s_classElementKey = new Hashtable();

    public static int getSavedClassStackIndex(Class<? extends SoElement> clazz) {
        Integer n = s_classStackIndex.get(clazz);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static void saveClassStackIndex(Class<? extends SoElement> clazz, int n) {
        Integer n2 = s_classStackIndex.get(clazz);
        if (n2 != null && n2 != n) {
            throw new IllegalArgumentException("ClassStackIndex map already contains a different value for this key.");
        }
        s_classStackIndex.put(clazz, n);
    }

    public static int getSavedClassElementKey(Class<? extends SoElement> clazz) {
        Integer n = s_classElementKey.get(clazz);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static void saveClassElementKey(Class<? extends SoElement> clazz, int n) {
        Integer n2 = s_classElementKey.get(clazz);
        if (n2 != null && n2 != n) {
            throw new IllegalArgumentException("ClassElementKey map already contains a different value for this key.");
        }
        s_classElementKey.put(clazz, n);
    }

    public static <E extends SoElement> int getClassStackIndex(final Class<E> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Element class is abstract");
        }
        Integer n = s_classStackIndex.get(clazz);
        if (n == null) {
            n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        SoElement soElement = (SoElement)constructor.newInstance(new Object[0]);
                        Integer n = s_classStackIndex.get(clazz);
                        ElementManager.deleteNativeElement(soElement);
                        return n;
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                        throw new SoInternalError("ElementManager.getClassStackIndex: " + String.valueOf(clazz) + " class does not define a default constructor.");
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                        throw new SoInternalError("ElementManager.getClassStackIndex: " + String.valueOf(clazz) + " class does not define a default constructor.");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    return -1;
                }
            });
        }
        return n;
    }

    private static <E extends SoElement> void deleteNativeElement(E e) {
        ElementManager.deleteNativeHandleImpl(e.getNativeResourceHandle());
    }

    private static native void deleteNativeHandleImpl(long var0);
}

