/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.NativeHandleMap;
import com.openinventor.inventor.errors.SoInternalError;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public abstract class GenericAbstractNativeResourceHandle<T>
extends WeakReference<T> {
    private static ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private Long handle;
    protected Class<?> wrapperClass;
    protected int refCounter;

    static ReferenceQueue<Object> referenceQueue() {
        return refQueue;
    }

    public GenericAbstractNativeResourceHandle(T t, long l) {
        super(t, refQueue);
        this.handle = l;
        this.wrapperClass = t.getClass();
        this.refCounter = 0;
        if (l == 0L) {
            System.err.println("setting handle to a non valid value");
        } else {
            NativeHandleMap.instance.addObjectMapping(l, this);
        }
    }

    public Long getHandle() {
        return this.handle;
    }

    public boolean isInvalid() {
        return this.handle == 0L;
    }

    void invalidate() {
        this.handle = 0L;
    }

    public void DangerousAddRef() {
        ++this.refCounter;
    }

    public void DangerousRelease() {
        if (this.refCounter <= 0) {
            throw new SoInternalError("trying to release twice the same native resource.");
        }
        --this.refCounter;
        if (this.refCounter == 0) {
            NativeHandleMap.instance.removeObjectMapping(this.handle);
        }
    }

    public int DangerousRefCounter() {
        return this.refCounter;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == GenericAbstractNativeResourceHandle.class) {
            GenericAbstractNativeResourceHandle genericAbstractNativeResourceHandle = (GenericAbstractNativeResourceHandle)object;
            return genericAbstractNativeResourceHandle.handle == this.handle;
        }
        return false;
    }
}

