/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.DynamicTypeManager;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.errors.SoInternalError;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class NativeTypeMap {
    public static Hashtable<String, Class<? extends Inventor>> s_nativeTypesToManaged;
    private static Hashtable<Class<? extends Inventor>, String> s_managedToNativeTypes;

    public static String getNativeTypeName(Class<? extends Inventor> clazz) {
        String string = s_managedToNativeTypes.get(clazz);
        if (string == null) {
            try {
                Method method = clazz.getDeclaredMethod("getClassTypeId", new Class[0]);
                return (String)ObjectManager.helperFor(clazz).invokeMethod(method, null, null);
            }
            catch (SecurityException securityException) {
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return string;
    }

    public static void addTypeMapping(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string != null) {
            s_nativeTypesToManaged.put(string, clazz);
        }
    }

    public static Class<? extends Inventor> getJavaClass(String string) {
        Class<? extends Inventor> clazz = s_nativeTypesToManaged.get(string);
        String string2 = string;
        while ((clazz == null || Modifier.isAbstract(clazz.getModifiers())) && (string2 = NativeTypeMap.getParentTypeName(string2)) != null) {
            clazz = s_nativeTypesToManaged.get(string2);
        }
        if (clazz == null || Modifier.isAbstract(clazz.getModifiers())) {
            throw new SoInternalError("Unable to find Java type for " + string);
        }
        return clazz;
    }

    private static native String getParentTypeName(String var0);

    public static boolean processCustomClass(Class<? extends Inventor> clazz) {
        boolean bl = s_managedToNativeTypes.get(clazz) == null;
        String string = DynamicTypeManager.getCompliantTypeName(clazz.getName());
        if (bl) {
            s_managedToNativeTypes.put(clazz, string);
            s_nativeTypesToManaged.put(string, clazz);
            return true;
        }
        return false;
    }

    static {
        s_managedToNativeTypes = new Hashtable();
        s_nativeTypesToManaged = new Hashtable();
        s_nativeTypesToManaged.put("Path", SoPath.class);
    }
}

