/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.GenericAbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.sensors.SoTimerSensor;
import java.lang.ref.ReferenceQueue;

public final class ProcessReferenceQueueBounded {
    private static final Runnable PROCESS_REF_QUEUE_TASK = new ProcessReferenceQueueTask();
    private static SoTimerSensor s_processRefQueueSensor = null;

    public static void init() {
        if (ObjectManager.DISPOSE_RESOURCE_ON_EVENT_DISPATCHING_THREAD) {
            if (s_processRefQueueSensor != null) {
                return;
            }
            SbTime sbTime = new SbTime(0.0);
            SbTime sbTime2 = new SbTime(0.1);
            s_processRefQueueSensor = new SoTimerSensor(PROCESS_REF_QUEUE_TASK);
            s_processRefQueueSensor.setBaseTime(sbTime);
            s_processRefQueueSensor.setInterval(sbTime2);
        }
    }

    public static void run() {
        if (ObjectManager.DISPOSE_RESOURCE_ON_EVENT_DISPATCHING_THREAD) {
            if (s_processRefQueueSensor != null && !s_processRefQueueSensor.isScheduled()) {
                s_processRefQueueSensor.schedule();
            }
        } else {
            PROCESS_REF_QUEUE_TASK.run();
        }
    }

    private static class ProcessReferenceQueueTask
    implements Runnable {
        private ProcessReferenceQueueTask() {
        }

        @Override
        public void run() {
            ReferenceQueue<Object> referenceQueue = GenericAbstractNativeResourceHandle.referenceQueue();
            GenericAbstractNativeResourceHandle genericAbstractNativeResourceHandle = null;
            do {
                if ((genericAbstractNativeResourceHandle = (GenericAbstractNativeResourceHandle)referenceQueue.poll()) == null || genericAbstractNativeResourceHandle.isInvalid()) continue;
                genericAbstractNativeResourceHandle.DangerousRelease();
            } while (genericAbstractNativeResourceHandle != null);
            if (s_processRefQueueSensor != null) {
                s_processRefQueueSensor.unschedule();
            }
        }
    }
}

