/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.ProcessReferenceQueueBounded;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.errors.SoInternalError;
import com.openinventor.inventor.internal.JarInitializer;
import java.util.Vector;

public abstract class Inventor {
    private AbstractNativeResourceHandle nativeResourceHandle = null;
    public static final int VERBOSE_LEVEL;
    public static final long ZeroHandle;
    private boolean m_hasDispose = false;

    static void doStaticInit() {
    }

    protected static <T extends Inventor> Vector<T> toVector(Class<T> clazz, long[] lArray) {
        Vector<T> vector = new Vector<T>();
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                vector.add(ObjectManager.getManagedObjectFor(clazz, lArray[i]));
            }
        }
        return vector;
    }

    protected void initializeNativeHandle(long l) {
        if (this.nativeResourceHandle == null) {
            this.setNativeResourceHandle(ConstructorCommand.CreateFromInstance, l);
        }
    }

    public synchronized Long getNativeResourceHandle() {
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.nativeResourceHandle.isClosed()) {
            throw new SoInternalError("Trying to use a native handle already closed.");
        }
        if (this.m_hasDispose) {
            throw new SoInternalError("Trying to use a native handle beeing closed.");
        }
        return this.nativeResourceHandle.getHandle();
    }

    private long getNativeResourceHandleInternal() {
        return this.getNativeResourceHandle();
    }

    protected void setNativeResourceHandle(ConstructorCommand constructorCommand, Long l) {
        if (this.nativeResourceHandle != null) {
            throw new SoInternalError("Trying to set twice native resource handle for the same object.");
        }
        this.nativeResourceHandle = this.createHandleForNativeResource(constructorCommand, l);
        this.nativeResourceHandle.DangerousAddRef();
    }

    protected abstract AbstractNativeResourceHandle createHandleForNativeResource(ConstructorCommand var1, long var2);

    protected void initializeFields() {
    }

    protected long createNativeObject(String string, Object ... objectArray) {
        throw new UnsupportedOperationException("Cannot create native object! createNativeObject method must be overridden.");
    }

    protected Inventor(ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        if (constructorCommand == ConstructorCommand.DontCreateInstance) {
            return;
        }
        this.setNativeResourceHandle(constructorCommand, this.createNativeObject(string, objectArray));
        ProcessReferenceQueueBounded.run();
    }

    protected Inventor(ConstructorCommand constructorCommand, long l) {
        if (constructorCommand == ConstructorCommand.DontCreateInstance) {
            return;
        }
        this.setNativeResourceHandle(constructorCommand, l);
        ProcessReferenceQueueBounded.run();
    }

    protected synchronized boolean hasDispose() {
        return this.m_hasDispose;
    }

    protected int getRefCount() {
        return this.nativeResourceHandle.DangerousRefCounter();
    }

    @Deprecated(since="9.0")
    public boolean dispose() {
        boolean bl;
        if (this.m_hasDispose) {
            return false;
        }
        boolean bl2 = bl = this.nativeResourceHandle != null && !this.nativeResourceHandle.isInvalid() && !this.nativeResourceHandle.isClosed() && !this.nativeResourceHandle.isEnqueued();
        if (bl) {
            this.internalDispose();
        }
        return bl;
    }

    protected synchronized void internalDispose() {
        if (VERBOSE_LEVEL > 1) {
            System.out.println("Dispose object of class " + String.valueOf(this.getClass()) + " with handle=" + this.getNativeResourceHandle());
        }
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.m_hasDispose || this.nativeResourceHandle.isInvalid() || this.nativeResourceHandle.isClosed()) {
            throw new IllegalStateException("Object already disposed.");
        }
        if (this.nativeResourceHandle.isEnqueued()) {
            throw new SoInternalError("Object already registered to be disposed.");
        }
        this.preMortenClean();
        boolean bl = this.nativeResourceHandle.enqueue();
        assert (bl);
        this.m_hasDispose = true;
        ProcessReferenceQueueBounded.run();
    }

    protected void preMortenClean() {
    }

    private static void printErrorMessage(String string) {
        System.err.println(string);
    }

    static {
        JarInitializer.checkInit();
        VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        if (SoPreferences.getValue("VSG_LICENSE_DEBUG") != null || SoPreferences.getValue("OIV_LICENSE_DEBUG") != null) {
            Package package_ = null;
            package_ = SoPreferences.class.getClassLoader() != null ? SoPreferences.class.getClassLoader().getDefinedPackage("com.openinventor.inventor") : ClassLoader.getSystemClassLoader().getDefinedPackage("com.openinventor.inventor");
            if (package_ != null) {
                System.out.println("");
                System.out.println("************************** Jar manifest content **************************");
                System.out.println("Specification Title    : " + package_.getSpecificationTitle());
                System.out.println("Specification vendor   : " + package_.getSpecificationVendor());
                System.out.println("Specification version  : " + package_.getSpecificationVersion());
                System.out.println("Implementation version : " + package_.getImplementationVersion());
                System.out.println("**************************************************************************");
                System.out.println("");
            }
        }
        ZeroHandle = 0L;
    }

    public static enum ConstructorCommand {
        CreateInstance,
        DontCreateInstance,
        CreateFromInstance;

    }
}

