/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbMatrixd;
import com.openinventor.inventor.SbVec3d;
import com.openinventor.inventor.internal.JniInitializer;

public class SbBox3d
extends SbBasic {
    public final double[] array;

    private static native void getMaxImpl(double[] var0, double[] var1);

    private static native void setBoundsImpl1(double[] var0, double[] var1, double[] var2);

    private static native void getCenterImpl(double[] var0, double[] var1);

    private static native void getBoundsImpl(double[] var0, double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6);

    private static native void getClosestPointImpl(double[] var0, double[] var1, double[] var2);

    private static native void getMinMaxImpl(double[] var0, double[] var1, double[] var2);

    private static native void getMinImpl(double[] var0, double[] var1);

    private static native void setBoundsImpl(double[] var0, double var1, double var3, double var5, double var7, double var9, double var11);

    private static native boolean containsImpl(double[] var0, double[] var1);

    private static native boolean intersectImpl1(double[] var0, double[] var1);

    private static native void intersectionImpl(double[] var0, double[] var1, double[] var2);

    private static native boolean intersectImpl(double[] var0, double[] var1);

    private static native void extendByImpl(double[] var0, double[] var1);

    private static native void extendByImpl1(double[] var0, double[] var1);

    private static native boolean outsideImpl(double[] var0, double[] var1, int[] var2);

    private static native void getOriginImpl(double[] var0, double[] var1, double[] var2, double[] var3);

    private static native double getVolumeImpl(double[] var0);

    private static native void transformImpl(double[] var0, double[] var1);

    private static native void checkSize();

    private static native boolean equalsImpl(double[] var0, double[] var1);

    private static native void setValueFromHandle(double[] var0, long var1);

    private static native void toArrayImpl(long var0, SbBox3d[] var2);

    private static native void getSpanImpl(double[] var0, double[] var1, double[] var2, double[] var3);

    private static native void makeEmptyImpl(double[] var0);

    private static native void ctorImpl1(double[] var0, double var1, double var3, double var5, double var7, double var9, double var11);

    private static native void getSizeImpl(double[] var0, double[] var1, double[] var2, double[] var3);

    private static native void ctorImpl2(double[] var0, double[] var1, double[] var2);

    private static native boolean hasVolumeImpl(double[] var0);

    private static native void ctorImpl(double[] var0);

    private static native boolean isEmptyImpl(double[] var0);

    protected SbBox3d(int n) {
        this.array = new double[n];
    }

    SbBox3d(long l) {
        this();
        SbBox3d.setValueFromHandle(this.array, l);
    }

    public double[] getValue() {
        return this.array;
    }

    public SbBox3d setValue(double[] dArray, int n) {
        if (n < 0 || n >= dArray.length - 6) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 6; ++i) {
            this.array[i] = dArray[n + i];
        }
        return this;
    }

    public SbBox3d(SbBox3d sbBox3d) {
        this();
        this.setValue(sbBox3d);
    }

    public SbBox3d(double[] dArray) {
        this(6);
        if (dArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (dArray.length != 6) {
            throw new IllegalArgumentException("Expected size is 6.");
        }
        this.setValue(dArray);
    }

    public SbBox3d setValue(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            this.array[i] = dArray[i];
        }
        return this;
    }

    public void setValue(SbBox3d sbBox3d) {
        this.setValue(sbBox3d.array);
    }

    public SbBox3d() {
        this(6);
        SbBox3d.ctorImpl(this.array);
    }

    public double[] getSpan(SbVec3d sbVec3d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        SbBox3d.getSpanImpl(this.array, sbVec3d != null ? sbVec3d.array : null, dArray, dArray2);
        double[] dArray3 = new double[]{dArray[0], dArray2[0]};
        return dArray3;
    }

    public boolean hasVolume() {
        return SbBox3d.hasVolumeImpl(this.array);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbBox3d) {
            SbBox3d sbBox3d = (SbBox3d)object;
            return SbBox3d.equalsImpl(this.array, sbBox3d.array);
        }
        return false;
    }

    public static SbBox3d[] toArray(long l, long l2) {
        SbBox3d[] sbBox3dArray = new SbBox3d[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbBox3dArray[n] = new SbBox3d();
            ++n;
        }
        SbBox3d.toArrayImpl(l, sbBox3dArray);
        return sbBox3dArray;
    }

    public void transform(SbMatrixd sbMatrixd) {
        SbBox3d.transformImpl(this.array, sbMatrixd != null ? sbMatrixd.array : null);
    }

    public double getVolume() {
        return SbBox3d.getVolumeImpl(this.array);
    }

    public void setBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        SbBox3d.setBoundsImpl(this.array, d, d2, d3, d4, d5, d6);
    }

    public SbBox3d(double d, double d2, double d3, double d4, double d5, double d6) {
        this(6);
        SbBox3d.ctorImpl1(this.array, d, d2, d3, d4, d5, d6);
    }

    public void extendBy(SbVec3d sbVec3d) {
        SbBox3d.extendByImpl(this.array, sbVec3d != null ? sbVec3d.array : null);
    }

    public void extendBy(SbBox3d sbBox3d) {
        SbBox3d.extendByImpl1(this.array, sbBox3d != null ? sbBox3d.array : null);
    }

    public SbVec3d getCenter() {
        SbVec3d sbVec3d = new SbVec3d();
        SbBox3d.getCenterImpl(this.array, sbVec3d.array);
        return sbVec3d;
    }

    public void setBounds(SbVec3d sbVec3d, SbVec3d sbVec3d2) {
        SbBox3d.setBoundsImpl1(this.array, sbVec3d != null ? sbVec3d.array : null, sbVec3d2 != null ? sbVec3d2.array : null);
    }

    public boolean intersect(SbVec3d sbVec3d) {
        return SbBox3d.intersectImpl(this.array, sbVec3d != null ? sbVec3d.array : null);
    }

    public boolean contains(SbBox3d sbBox3d) {
        return SbBox3d.containsImpl(this.array, sbBox3d != null ? sbBox3d.array : null);
    }

    public SbBox3d intersection(SbBox3d sbBox3d) {
        SbBox3d sbBox3d2 = new SbBox3d();
        SbBox3d.intersectionImpl(this.array, sbBox3d != null ? sbBox3d.array : null, sbBox3d2.array);
        return sbBox3d2;
    }

    public int outside(SbMatrixd sbMatrixd) {
        int[] nArray = new int[1];
        boolean bl = false;
        bl = SbBox3d.outsideImpl(this.array, sbMatrixd != null ? sbMatrixd.array : null, nArray);
        if (bl) {
            return nArray[0];
        }
        return 0;
    }

    public boolean intersect(SbBox3d sbBox3d) {
        return SbBox3d.intersectImpl1(this.array, sbBox3d != null ? sbBox3d.array : null);
    }

    public double[] getBounds() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        SbBox3d.getBoundsImpl(this.array, dArray, dArray2, dArray3, dArray4, dArray5, dArray6);
        double[] dArray7 = new double[]{dArray[0], dArray2[0], dArray3[0], dArray4[0], dArray5[0], dArray6[0]};
        return dArray7;
    }

    public void makeEmpty() {
        SbBox3d.makeEmptyImpl(this.array);
    }

    public double[] getSize() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        SbBox3d.getSizeImpl(this.array, dArray, dArray2, dArray3);
        double[] dArray4 = new double[]{dArray[0], dArray2[0], dArray3[0]};
        return dArray4;
    }

    public boolean isEmpty() {
        return SbBox3d.isEmptyImpl(this.array);
    }

    public SbBox3d(SbVec3d sbVec3d, SbVec3d sbVec3d2) {
        this(6);
        SbBox3d.ctorImpl2(this.array, sbVec3d != null ? sbVec3d.array : null, sbVec3d2 != null ? sbVec3d2.array : null);
    }

    public double[] getOrigin() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        SbBox3d.getOriginImpl(this.array, dArray, dArray2, dArray3);
        double[] dArray4 = new double[]{dArray[0], dArray2[0], dArray3[0]};
        return dArray4;
    }

    public SbVec3d[] getMinMax() {
        SbVec3d sbVec3d = new SbVec3d();
        SbVec3d sbVec3d2 = new SbVec3d();
        SbBox3d.getMinMaxImpl(this.array, sbVec3d != null ? sbVec3d.array : null, sbVec3d2 != null ? sbVec3d2.array : null);
        SbVec3d[] sbVec3dArray = new SbVec3d[]{sbVec3d, sbVec3d2};
        return sbVec3dArray;
    }

    public SbVec3d getMax() {
        SbVec3d sbVec3d = new SbVec3d();
        SbBox3d.getMaxImpl(this.array, sbVec3d.array);
        return sbVec3d;
    }

    public SbVec3d getClosestPoint(SbVec3d sbVec3d) {
        SbVec3d sbVec3d2 = new SbVec3d();
        SbBox3d.getClosestPointImpl(this.array, sbVec3d != null ? sbVec3d.array : null, sbVec3d2.array);
        return sbVec3d2;
    }

    public SbVec3d getMin() {
        SbVec3d sbVec3d = new SbVec3d();
        SbBox3d.getMinImpl(this.array, sbVec3d.array);
        return sbVec3d;
    }

    static {
        JniInitializer.checkInit();
        SbBox3d.checkSize();
    }
}

