/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.internal.JniInitializer;

public class SbBox3f
extends SbBasic {
    public final float[] array;

    private static native void getBoundsImpl(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6);

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void setBoundsImpl(float[] var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native void getOriginImpl(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native void getClosestPointImpl(float[] var0, float[] var1, float[] var2);

    private static native void getMinMaxImpl(float[] var0, float[] var1, float[] var2);

    private static native boolean intersectImpl1(float[] var0, float[] var1);

    private static native boolean intersectImpl(float[] var0, float[] var1);

    private static native void extendByImpl1(float[] var0, float[] var1);

    private static native boolean outsideImpl(float[] var0, float[] var1, int[] var2);

    private static native boolean containsImpl(float[] var0, float[] var1);

    private static native void intersectionImpl(float[] var0, float[] var1, float[] var2);

    private static native float computeMaxDistance2Impl(float[] var0, float[] var1);

    private static native boolean equalsImpl(float[] var0, float[] var1);

    private static native float getVolumeImpl(float[] var0);

    private static native void toArrayImpl(long var0, SbBox3f[] var2);

    private static native boolean triangleBoxOverlapImpl(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native boolean isEmptyImpl(float[] var0);

    private static native void makeEmptyImpl(float[] var0);

    private static native void getSizeImpl(float[] var0, float[] var1);

    private static native void transformImpl(float[] var0, float[] var1);

    private static native void getSpanImpl(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native boolean hasVolumeImpl(float[] var0);

    private static native void extendByImpl(float[] var0, float[] var1);

    private static native void ctorImpl1(float[] var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native void getMinImpl(float[] var0, float[] var1);

    private static native void getMaxImpl(float[] var0, float[] var1);

    private static native void ctorImpl2(float[] var0, float[] var1, float[] var2);

    private static native void ctorImpl(float[] var0);

    private static native void setBoundsImpl1(float[] var0, float[] var1, float[] var2);

    private static native void getCenterImpl(float[] var0, float[] var1);

    private static native void checkSize();

    protected SbBox3f(int n) {
        this.array = new float[n];
    }

    SbBox3f(long l) {
        this();
        SbBox3f.setValueFromHandle(this.array, l);
    }

    public SbBox3f(SbBox3f sbBox3f) {
        this();
        this.setValue(sbBox3f);
    }

    public SbBox3f setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 6) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 6; ++i) {
            this.array[i] = fArray[n + i];
        }
        return this;
    }

    public SbBox3f setValue(float[] fArray) {
        for (int i = 0; i < 6; ++i) {
            this.array[i] = fArray[i];
        }
        return this;
    }

    public float[] getValue() {
        return this.array;
    }

    public void setValue(SbBox3f sbBox3f) {
        this.setValue(sbBox3f.array);
    }

    public SbBox3f(float[] fArray) {
        this(6);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 6) {
            throw new IllegalArgumentException("Expected size is 6.");
        }
        this.setValue(fArray);
    }

    public float computeMaxDistance2(SbVec3f sbVec3f) {
        return SbBox3f.computeMaxDistance2Impl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void transform(SbMatrix sbMatrix) {
        SbBox3f.transformImpl(this.array, sbMatrix != null ? sbMatrix.array : null);
    }

    public void extendBy(SbBox3f sbBox3f) {
        SbBox3f.extendByImpl1(this.array, sbBox3f != null ? sbBox3f.array : null);
    }

    public float getVolume() {
        return SbBox3f.getVolumeImpl(this.array);
    }

    public boolean triangleBoxOverlap(SbVec3f sbVec3f, SbVec3f sbVec3f2, SbVec3f sbVec3f3) {
        return SbBox3f.triangleBoxOverlapImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbVec3f3 != null ? sbVec3f3.array : null);
    }

    public static SbBox3f[] toArray(long l, long l2) {
        SbBox3f[] sbBox3fArray = new SbBox3f[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbBox3fArray[n] = new SbBox3f();
            ++n;
        }
        SbBox3f.toArrayImpl(l, sbBox3fArray);
        return sbBox3fArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbBox3f) {
            SbBox3f sbBox3f = (SbBox3f)object;
            return SbBox3f.equalsImpl(this.array, sbBox3f.array);
        }
        return false;
    }

    public float[] getSpan(SbVec3f sbVec3f) {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        SbBox3f.getSpanImpl(this.array, sbVec3f != null ? sbVec3f.array : null, fArray, fArray2);
        float[] fArray3 = new float[]{fArray[0], fArray2[0]};
        return fArray3;
    }

    public int outside(SbMatrix sbMatrix) {
        int[] nArray = new int[1];
        boolean bl = false;
        bl = SbBox3f.outsideImpl(this.array, sbMatrix != null ? sbMatrix.array : null, nArray);
        if (bl) {
            return nArray[0];
        }
        return 0;
    }

    public SbVec3f getMax() {
        SbVec3f sbVec3f = new SbVec3f();
        SbBox3f.getMaxImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public void setBounds(float f, float f2, float f3, float f4, float f5, float f6) {
        SbBox3f.setBoundsImpl(this.array, f, f2, f3, f4, f5, f6);
    }

    public SbVec3f getMin() {
        SbVec3f sbVec3f = new SbVec3f();
        SbBox3f.getMinImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public void setBounds(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        SbBox3f.setBoundsImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
    }

    public boolean contains(SbBox3f sbBox3f) {
        return SbBox3f.containsImpl(this.array, sbBox3f != null ? sbBox3f.array : null);
    }

    public boolean intersect(SbVec3f sbVec3f) {
        return SbBox3f.intersectImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void extendBy(SbVec3f sbVec3f) {
        SbBox3f.extendByImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public boolean intersect(SbBox3f sbBox3f) {
        return SbBox3f.intersectImpl1(this.array, sbBox3f != null ? sbBox3f.array : null);
    }

    public SbBox3f intersection(SbBox3f sbBox3f) {
        SbBox3f sbBox3f2 = new SbBox3f();
        SbBox3f.intersectionImpl(this.array, sbBox3f != null ? sbBox3f.array : null, sbBox3f2.array);
        return sbBox3f2;
    }

    public SbVec3f getCenter() {
        SbVec3f sbVec3f = new SbVec3f();
        SbBox3f.getCenterImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public SbBox3f(float f, float f2, float f3, float f4, float f5, float f6) {
        this(6);
        SbBox3f.ctorImpl1(this.array, f, f2, f3, f4, f5, f6);
    }

    public void makeEmpty() {
        SbBox3f.makeEmptyImpl(this.array);
    }

    public boolean isEmpty() {
        return SbBox3f.isEmptyImpl(this.array);
    }

    public SbBox3f() {
        this(6);
        SbBox3f.ctorImpl(this.array);
    }

    public boolean hasVolume() {
        return SbBox3f.hasVolumeImpl(this.array);
    }

    public SbVec3f getSize() {
        SbVec3f sbVec3f = new SbVec3f();
        SbBox3f.getSizeImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public SbVec3f[] getMinMax() {
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f sbVec3f2 = new SbVec3f();
        SbBox3f.getMinMaxImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        SbVec3f[] sbVec3fArray = new SbVec3f[]{sbVec3f, sbVec3f2};
        return sbVec3fArray;
    }

    public float[] getBounds() {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        float[] fArray3 = new float[1];
        float[] fArray4 = new float[1];
        float[] fArray5 = new float[1];
        float[] fArray6 = new float[1];
        SbBox3f.getBoundsImpl(this.array, fArray, fArray2, fArray3, fArray4, fArray5, fArray6);
        float[] fArray7 = new float[]{fArray[0], fArray2[0], fArray3[0], fArray4[0], fArray5[0], fArray6[0]};
        return fArray7;
    }

    public SbVec3f getClosestPoint(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbBox3f.getClosestPointImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2.array);
        return sbVec3f2;
    }

    public SbBox3f(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this(6);
        SbBox3f.ctorImpl2(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
    }

    public float[] getOrigin() {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        float[] fArray3 = new float[1];
        SbBox3f.getOriginImpl(this.array, fArray, fArray2, fArray3);
        float[] fArray4 = new float[]{fArray[0], fArray2[0], fArray3[0]};
        return fArray4;
    }

    static {
        JniInitializer.checkInit();
        SbBox3f.checkSize();
    }
}

