/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventListener;
import java.util.ArrayList;
import java.util.List;

public abstract class SbEventHandler<E extends SbEventArg> {
    protected List<SbEventListener<E>> m_listeners = new ArrayList<SbEventListener<E>>();
    protected long m_nativeEventHandler;

    public boolean addEventListener(SbEventListener<E> sbEventListener) {
        if (!this.m_listeners.contains(sbEventListener)) {
            if (this.m_listeners.isEmpty()) {
                this.addNativeEventHandler();
            }
            return this.m_listeners.add(sbEventListener);
        }
        return false;
    }

    public boolean removeEventListener(SbEventListener<E> sbEventListener) {
        boolean bl = this.m_listeners.remove(sbEventListener);
        if (bl && this.m_listeners.isEmpty()) {
            this.removeNativeEventHandler();
        }
        return bl;
    }

    public void clear() {
        this.m_listeners.clear();
        this.removeNativeEventHandler();
    }

    protected void raiseEvent(E e) {
        for (SbEventListener<E> sbEventListener : this.m_listeners) {
            sbEventListener.onEvent(e);
        }
    }

    protected abstract void addNativeEventHandler();

    protected abstract void removeNativeEventHandler();
}

