/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.ProcessReferenceQueueBounded;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoSystemTimer;

public class SoDB
extends Inventor {
    private static SoSystemTimer m_systemTimer;

    public static SoNode readNode(SoInput soInput) {
        long l = SoDB.readNodeImpl(soInput.getNativeResourceHandle());
        if (l != 0L) {
            return ObjectManager.getManagedObjectFor(SoNode.class, l);
        }
        return null;
    }

    protected static native long readNodeImpl(long var0);

    static void initGuiThread() {
        SoDB.resetOivCppMainThreadIdNative();
    }

    private static native void resetOivCppMainThreadIdNative();

    private static void onSetSystemTimer(SoSystemTimer soSystemTimer) {
        if (m_systemTimer != null) {
            return;
        }
        m_systemTimer = soSystemTimer;
        ProcessReferenceQueueBounded.init();
    }

    private SoDB() {
        super(Inventor.ConstructorCommand.DontCreateInstance, 0L);
    }

    private static native void setDelaySensorTimeoutImpl(long var0);

    private static native String getConverterImpl(String var0, String var1);

    private static native void getRealTimeIntervalImpl(long var0);

    private static native boolean removePluginsDirectoryImpl(String var0);

    private static native void getDelaySensorTimeoutImpl(long var0);

    private static native void addConverterImpl(String var0, String var1, String var2);

    private static native void renameGlobalFieldImpl(String var0, String var1);

    private static native boolean getIvTuneAllowedImpl();

    private static native long getGlobalFieldImpl(String var0);

    private static native void removeConverterImpl(String var0, String var1);

    private static native void setRealTimeIntervalImpl(long var0);

    private static native void setIvTuneAllowedImpl(boolean var0);

    private static native void processEventsImpl();

    private static native void setRenderCacheModeImpl(int var0);

    private static native void readlockImpl();

    private static native int getRenderCacheModeImpl();

    private static native void setNumRenderCachesImpl(int var0);

    private static native int getNumRenderCachesImpl();

    private static native void readunlockImpl();

    private static native boolean isMultiThreadImpl();

    private static native boolean removePluginImpl(String var0);

    private static native boolean addPluginsDirectoryImpl(String var0);

    private static native void writeunlockImpl();

    private static native void writelockImpl();

    private static native boolean addPluginImpl(String var0);

    private static native boolean readPathImpl(long var0, long[] var2);

    private static native boolean readImpl(long var0, long[] var2);

    private static native long readAllImpl(long var0);

    private static native void getCurrentTimeImpl(long var0);

    private static native void setSystemTimerImpl(long var0);

    private static native String getHeaderStringImpl(int var0);

    private static native long createGlobalFieldImpl(String var0, String var1);

    private static native boolean isValidHeaderImpl(String var0);

    private static native int getNumHeadersImpl();

    protected SoDB(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public static SoField createGlobalField(String string, Class<? extends Inventor> clazz) {
        String string2 = NativeTypeMap.getNativeTypeName(clazz);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        return ObjectManager.getManagedObjectFor(SoField.class, SoDB.createGlobalFieldImpl(string, string2));
    }

    public static boolean isValidHeader(String string) {
        return SoDB.isValidHeaderImpl(string);
    }

    public static void readlock() {
        SoDB.readlockImpl();
    }

    public static SbTime getCurrentTime() {
        SbTime sbTime = new SbTime();
        SoDB.getCurrentTimeImpl(sbTime.getNativeResourceHandle());
        return sbTime;
    }

    @Deprecated(since="10.3.0.0")
    public static RenderCacheModes getRenderCacheMode() {
        return IntegerValuedEnumHelper.fromIntValue(RenderCacheModes.class, SoDB.getRenderCacheModeImpl());
    }

    public static SoField getGlobalField(String string) {
        return ObjectManager.getManagedObjectFor(SoField.class, SoDB.getGlobalFieldImpl(string));
    }

    public static void readunlock() {
        SoDB.readunlockImpl();
    }

    public static String getHeaderString(int n) {
        return SoDB.getHeaderStringImpl(n);
    }

    public static SoNode read(SoInput soInput) {
        long[] lArray = new long[1];
        boolean bl = false;
        bl = SoDB.readImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoNode.class, lArray[0]);
        }
        return null;
    }

    public static SoPath readPath(SoInput soInput) {
        long[] lArray = new long[1];
        boolean bl = false;
        bl = SoDB.readPathImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoPath.class, lArray[0]);
        }
        return null;
    }

    public static void setSystemTimer(SoSystemTimer soSystemTimer) {
        SoDB.setSystemTimerImpl(soSystemTimer != null ? soSystemTimer.getNativeResourceHandle() : Inventor.ZeroHandle);
        SoDB.onSetSystemTimer(soSystemTimer);
    }

    @Deprecated(since="10.3.0.0")
    public static void setNumRenderCaches(int n) {
        SoDB.setNumRenderCachesImpl(n);
    }

    @Deprecated(since="10.3.0.0")
    public static void setRenderCacheMode(RenderCacheModes renderCacheModes) {
        SoDB.setRenderCacheModeImpl(renderCacheModes.getValue());
    }

    public static int getNumHeaders() {
        return SoDB.getNumHeadersImpl();
    }

    @Deprecated(since="10.3.0.0")
    public static int getNumRenderCaches() {
        return SoDB.getNumRenderCachesImpl();
    }

    public static SoSeparator readAll(SoInput soInput) {
        return ObjectManager.getManagedObjectFor(SoSeparator.class, SoDB.readAllImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public static void setDelaySensorTimeout(SbTime sbTime) {
        SoDB.setDelaySensorTimeoutImpl(sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static void removeConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        SoDB.removeConverterImpl(string, string2);
    }

    public static SbTime getDelaySensorTimeout() {
        SbTime sbTime = new SbTime();
        SoDB.getDelaySensorTimeoutImpl(sbTime.getNativeResourceHandle());
        return sbTime;
    }

    public static Class<? extends Inventor> getConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        return NativeTypeMap.getJavaClass(SoDB.getConverterImpl(string, string2));
    }

    public static SbTime getRealTimeInterval() {
        SbTime sbTime = new SbTime();
        SoDB.getRealTimeIntervalImpl(sbTime.getNativeResourceHandle());
        return sbTime;
    }

    public static void renameGlobalField(String string, String string2) {
        SoDB.renameGlobalFieldImpl(string, string2);
    }

    public static boolean getIvTuneAllowed() {
        return SoDB.getIvTuneAllowedImpl();
    }

    public static void setIvTuneAllowed(boolean bl) {
        SoDB.setIvTuneAllowedImpl(bl);
    }

    public static void setRealTimeInterval(SbTime sbTime) {
        SoDB.setRealTimeIntervalImpl(sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static void writelock() {
        SoDB.writelockImpl();
    }

    public static boolean removePlugin(String string) {
        return SoDB.removePluginImpl(string);
    }

    public static void writeunlock() {
        SoDB.writeunlockImpl();
    }

    public static boolean addPlugin(String string) {
        return SoDB.addPluginImpl(string);
    }

    @Deprecated(since="10.0.0.0")
    public static boolean isMultiThread() {
        return SoDB.isMultiThreadImpl();
    }

    public static void processEvents() {
        SoDB.processEventsImpl();
    }

    public static void addConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2, Class<? extends Inventor> clazz3) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = NativeTypeMap.getNativeTypeName(clazz3);
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        SoDB.addConverterImpl(string, string2, string3);
    }

    public static boolean addPluginsDirectory(String string) {
        return SoDB.addPluginsDirectoryImpl(string);
    }

    public static boolean removePluginsDirectory(String string) {
        return SoDB.removePluginsDirectoryImpl(string);
    }

    static {
        JniInitializer.checkInit();
        m_systemTimer = null;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    @Deprecated(since="10.3.0.0")
    public static enum RenderCacheModes implements IntegerValuedEnum
    {
        COMPILE(RenderCacheModes.getCOMPILE()),
        COMPILE_AND_EXECUTE(RenderCacheModes.getCOMPILEANDEXECUTE()),
        AUTO_RENDER_CACHE(RenderCacheModes.getAUTORENDERCACHE());

        private int value;

        private static native int getAUTORENDERCACHENative();

        private static int getAUTORENDERCACHE() {
            JniInitializer.checkInit();
            return RenderCacheModes.getAUTORENDERCACHENative();
        }

        private RenderCacheModes(int n2) {
            this.value = n2;
        }

        private static int getCOMPILEANDEXECUTE() {
            JniInitializer.checkInit();
            return RenderCacheModes.getCOMPILEANDEXECUTENative();
        }

        private static native int getCOMPILENative();

        private static int getCOMPILE() {
            JniInitializer.checkInit();
            return RenderCacheModes.getCOMPILENative();
        }

        private static native int getCOMPILEANDEXECUTENative();

        public static RenderCacheModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderCacheModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

