/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.image.SbRasterImage;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.SiRenderArea;
import com.openinventor.inventor.viewercomponents.SiRenderAreaAntialiasing;
import com.openinventor.inventor.viewercomponents.SiRenderAreaTransparency;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;

public class SoOffscreenRenderArea
extends Inventor
implements SiRenderArea,
SiRenderAreaAntialiasing,
SiRenderAreaTransparency,
SafeDisposable {
    public final SbEventHandler<EventArg> onTileRendered;
    private SoGLRenderAction m_glAction_setGLRenderAction;
    private final SbEventHandler<SiRenderArea.RenderEventArg> onStartRender;

    private static native boolean renderToBufferImpl(long var0, long var2, int var4);

    private static native boolean renderToFileImpl(long var0, String var2, int var3);

    private static native boolean removeOnStartRenderEventHandler(long var0, long var2);

    private static native long addOnStartRenderEventHandler(long var0, OnStartRenderEventHandler var2, String var3);

    private static native void setTileImpl(long var0, int[] var2, int var3);

    private static native void setAntialiasingModeImpl(long var0, int var2);

    private static native void setAntialiasingQualityImpl(long var0, float var2);

    private static native void setClearDepthImpl(long var0, float var2);

    private static native int getTransparencyTypeImpl(long var0);

    private static native long getSceneManagerImpl(long var0);

    private static native int getAntialiasingModeImpl(long var0);

    private static native void setSizeImpl(long var0, int[] var2);

    private static native void setClearPolicyImpl(long var0, int var2);

    private static native void setClearColorImpl(long var0, float[] var2);

    private static native void getClearColorImpl(long var0, float[] var2);

    private static native float getClearDepthImpl(long var0);

    private static native void getSizeImpl(long var0, int[] var2);

    private static native long getGLRenderActionImpl(long var0);

    private static native void getTileSizeImpl(long var0, int[] var2);

    private static native int getNumEdgePixelsImpl(long var0);

    private static native int getClearPolicyImpl(long var0);

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native long ctorImpl1(long var0);

    private static native long ctorImpl2(long var0);

    private static native void setSceneGraphImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void setTransparencyTypeImpl(long var0, int var2);

    private static native long addOnTileRenderedEventHandler(long var0, OnTileRenderedEventHandler var2, String var3);

    private static native boolean removeOnTileRenderedEventHandler(long var0, long var2);

    private static native int renderImpl(long var0);

    private static native long getSceneGraphImpl(long var0);

    private static native void getMaxTileSizeImpl(int[] var0);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native float getAntialiasingQualityImpl(long var0);

    private static native void getViewportRegionImpl(long var0, long var2);

    protected SoOffscreenRenderArea(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.onTileRendered = new OnTileRenderedEventHandler();
        this.onStartRender = new OnStartRenderEventHandler();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public SbEventHandler<SiRenderArea.RenderEventArg> onStartRender() {
        return this.onStartRender;
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    public boolean renderToBuffer(SoBufferObject soBufferObject) {
        return this.renderToBuffer(soBufferObject, OutputFormats.valueOf(OutputFormats.RGB.getValue()));
    }

    public boolean renderToFile(String string) {
        return this.renderToFile(string, OutputFormats.valueOf(OutputFormats.RGB.getValue()));
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        SoOffscreenRenderArea.setTransparencyTypeImpl(this.getNativeResourceHandle(), transparencyTypes.getValue());
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        SoOffscreenRenderArea.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        return sbViewportRegion;
    }

    @Override
    public SiRenderArea.RenderStatus render() {
        return IntegerValuedEnumHelper.fromIntValue(SiRenderArea.RenderStatus.class, SoOffscreenRenderArea.renderImpl(this.getNativeResourceHandle()));
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        return IntegerValuedEnumHelper.fromIntValue(SoGLRenderAction.TransparencyTypes.class, SoOffscreenRenderArea.getTransparencyTypeImpl(this.getNativeResourceHandle()));
    }

    @Override
    public void setAntialiasingQuality(float f) {
        SoOffscreenRenderArea.setAntialiasingQualityImpl(this.getNativeResourceHandle(), f);
    }

    public SoSceneManager getSceneManager() {
        return ObjectManager.getManagedObjectFor(SoSceneManager.class, SoOffscreenRenderArea.getSceneManagerImpl(this.getNativeResourceHandle()));
    }

    @Override
    public float getAntialiasingQuality() {
        return SoOffscreenRenderArea.getAntialiasingQualityImpl(this.getNativeResourceHandle());
    }

    public static SbVec2i32 getMaxTileSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        SoOffscreenRenderArea.getMaxTileSizeImpl(sbVec2i32.array);
        return sbVec2i32;
    }

    public SoOffscreenRenderArea(SoGLContext soGLContext) {
        this(Inventor.ConstructorCommand.CreateInstance, SoOffscreenRenderArea.ctorImpl1(soGLContext != null ? soGLContext.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SoOffscreenRenderArea() {
        this(Inventor.ConstructorCommand.CreateInstance, SoOffscreenRenderArea.ctorImpl());
    }

    @Override
    public void setClearPolicy(SiRenderArea.ClearPolicies clearPolicies) {
        SoOffscreenRenderArea.setClearPolicyImpl(this.getNativeResourceHandle(), clearPolicies.getValue());
    }

    public SoOffscreenRenderArea(SoRenderAreaCore soRenderAreaCore) {
        this(Inventor.ConstructorCommand.CreateInstance, SoOffscreenRenderArea.ctorImpl2(soRenderAreaCore != null ? soRenderAreaCore.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        SoOffscreenRenderArea.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Override
    public SoNode getSceneGraph() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoOffscreenRenderArea.getSceneGraphImpl(this.getNativeResourceHandle()));
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        SoOffscreenRenderArea.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Override
    public SbVec2i32 getSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        SoOffscreenRenderArea.getSizeImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        return sbVec2i32;
    }

    @Override
    public void setClearColor(SbColorRGBA sbColorRGBA) {
        SoOffscreenRenderArea.setClearColorImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
    }

    @Override
    public SiRenderArea.ClearPolicies getClearPolicy() {
        return IntegerValuedEnumHelper.fromIntValue(SiRenderArea.ClearPolicies.class, SoOffscreenRenderArea.getClearPolicyImpl(this.getNativeResourceHandle()));
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_glAction_setGLRenderAction = soGLRenderAction;
        SoOffscreenRenderArea.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Override
    public float getClearDepth() {
        return SoOffscreenRenderArea.getClearDepthImpl(this.getNativeResourceHandle());
    }

    @Override
    public void setClearDepth(float f) {
        SoOffscreenRenderArea.setClearDepthImpl(this.getNativeResourceHandle(), f);
    }

    @Override
    public void setSize(SbVec2i32 sbVec2i32) {
        SoOffscreenRenderArea.setSizeImpl(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null);
    }

    @Override
    public SbColorRGBA getClearColor() {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        SoOffscreenRenderArea.getClearColorImpl(this.getNativeResourceHandle(), sbColorRGBA.array);
        return sbColorRGBA;
    }

    @Override
    public void setAntialiasingMode(SoSceneManager.AntialiasingModes antialiasingModes) {
        SoOffscreenRenderArea.setAntialiasingModeImpl(this.getNativeResourceHandle(), antialiasingModes.getValue());
    }

    public boolean renderToBuffer(SoBufferObject soBufferObject, OutputFormats outputFormats) {
        return SoOffscreenRenderArea.renderToBufferImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, outputFormats.getValue());
    }

    @Override
    public SoSceneManager.AntialiasingModes getAntialiasingMode() {
        return IntegerValuedEnumHelper.fromIntValue(SoSceneManager.AntialiasingModes.class, SoOffscreenRenderArea.getAntialiasingModeImpl(this.getNativeResourceHandle()));
    }

    public boolean renderToFile(String string, OutputFormats outputFormats) {
        return SoOffscreenRenderArea.renderToFileImpl(this.getNativeResourceHandle(), string, outputFormats.getValue());
    }

    public int getNumEdgePixels() {
        return SoOffscreenRenderArea.getNumEdgePixelsImpl(this.getNativeResourceHandle());
    }

    public SoGLRenderAction getGLRenderAction() {
        return ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoOffscreenRenderArea.getGLRenderActionImpl(this.getNativeResourceHandle()));
    }

    public void setTile(SbVec2i32 sbVec2i32, int n) {
        SoOffscreenRenderArea.setTileImpl(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null, n);
    }

    public SbVec2i32 getTileSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        SoOffscreenRenderArea.getTileSizeImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        return sbVec2i32;
    }

    private class OnTileRenderedEventHandler
    extends SbEventHandler<EventArg> {
        private OnTileRenderedEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoOffscreenRenderArea.removeOnTileRenderedEventHandler(SoOffscreenRenderArea.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = EventArg.class.getName();
            this.m_nativeEventHandler = SoOffscreenRenderArea.addOnTileRenderedEventHandler(SoOffscreenRenderArea.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnStartRenderEventHandler
    extends SbEventHandler<SiRenderArea.RenderEventArg> {
        private OnStartRenderEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoOffscreenRenderArea.removeOnStartRenderEventHandler(SoOffscreenRenderArea.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = SiRenderArea.RenderEventArg.class.getName();
            this.m_nativeEventHandler = SoOffscreenRenderArea.addOnStartRenderEventHandler(SoOffscreenRenderArea.this.getNativeResourceHandle(), this, string);
        }
    }

    public static enum OutputFormats implements IntegerValuedEnum
    {
        RGB(OutputFormats.getRGB()),
        RGBA(OutputFormats.getRGBA());

        private int value;

        private static int getRGBA() {
            JniInitializer.checkInit();
            return OutputFormats.getRGBANative();
        }

        private OutputFormats(int n2) {
            this.value = n2;
        }

        private static native int getRGBANative();

        private static native int getRGBNative();

        private static int getRGB() {
            JniInitializer.checkInit();
            return OutputFormats.getRGBNative();
        }

        public static OutputFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(OutputFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static class EventArg
    extends Inventor
    implements SbEventArg {
        private static native long getTileImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native int getNumTilesImpl(long var0);

        private static native long getSourceImpl(long var0);

        private static native void getOriginImpl(long var0, int[] var2);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected EventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public void setValue(EventArg eventArg) {
            EventArg.setValueImpl(this.getNativeResourceHandle(), eventArg.getNativeResourceHandle());
        }

        public SbVec2i32 getOrigin() {
            SbVec2i32 sbVec2i32 = new SbVec2i32();
            EventArg.getOriginImpl(this.getNativeResourceHandle(), sbVec2i32.array);
            return sbVec2i32;
        }

        public int getNumTiles() {
            return EventArg.getNumTilesImpl(this.getNativeResourceHandle());
        }

        public SbRasterImage getTile() {
            return ObjectManager.getManagedObjectFor(SbRasterImage.class, EventArg.getTileImpl(this.getNativeResourceHandle()));
        }

        @Override
        public SoOffscreenRenderArea getSource() {
            return ObjectManager.getManagedObjectFor(SoOffscreenRenderArea.class, EventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }
}

