/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoGeneralPath;
import com.openinventor.inventor.SoNodeKitPath;
import com.openinventor.inventor.SoPathDotFullPath;
import com.openinventor.inventor.SoPathDotInnerPath;
import com.openinventor.inventor.SoPathDotNodekitPath;
import com.openinventor.inventor.SoPathDotRegularPath;
import com.openinventor.inventor.misc.SoBase;
import com.openinventor.inventor.nodekits.SoBaseKit;
import com.openinventor.inventor.nodes.SoNode;

public class SoPath
extends SoBase {
    public SoGeneralPath full = new fullPath();
    public SoGeneralPath regular = new regularPath();
    public SoNodeKitPath nodekit = new nodekitPath();

    protected boolean nativeConstructorInSoBase() {
        return false;
    }

    protected SoPath(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
    }

    public SoPath() {
        this(0);
    }

    public SoPath(SoNode soNode) {
        this(0);
        this.regular.setHead(soNode);
    }

    public SoPath(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoPath.constructor(n));
    }

    protected static native long constructor(int var0);

    public static SoPath getByName(String string) {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoPath.getByNameNativ(string));
    }

    protected static native long getByNameNativ(String var0);

    public static SoPath[] getAllByName(String string) {
        long[] lArray = SoPath.getAllByNameImpl(string);
        SoPath[] soPathArray = new SoPath[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            soPathArray[i] = ObjectManager.getManagedObjectFor(SoPath.class, lArray[i]);
        }
        return soPathArray;
    }

    private static native long[] getAllByNameImpl(String var0);

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        SoPath soPath = (SoPath)object;
        if (this.getNativeResourceHandle() == soPath.getNativeResourceHandle()) {
            return true;
        }
        return this.equalsNativ(this.getNativeResourceHandle(), soPath.getNativeResourceHandle());
    }

    protected native boolean equalsNativ(long var1, long var3);

    private class fullPath
    extends InnerPath
    implements SoGeneralPath {
        private SoPathDotFullPath m_nativPath;

        private fullPath() {
            this.m_nativPath = new SoPathDotFullPath();
        }

        @Override
        SoPathDotInnerPath getNativPath() {
            return this.m_nativPath;
        }

        @Override
        public boolean containsNode(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return this.m_nativPath.containsNodeClass(SoPath.this.getNativeResourceHandle(), clazz.getName());
        }

        @Override
        public SoNode getNode(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return ObjectManager.getManagedObjectFor(SoNode.class, this.m_nativPath.getNodeClass(SoPath.this.getNativeResourceHandle(), clazz.getName()));
        }

        @Override
        public int getIndex(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return this.m_nativPath.getIndexClass(SoPath.this.getNativeResourceHandle(), clazz.getName());
        }

        @Override
        public void append(int n) {
            this.m_nativPath.append(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public void append(SoNode soNode) {
            this.m_nativPath.appendNode(SoPath.this.getNativeResourceHandle(), soNode.getNativeResourceHandle());
        }

        @Override
        public void push(int n) {
            this.m_nativPath.push(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getIndex(int n) {
            return this.m_nativPath.getIndex(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getIndexFromTail(int n) {
            return this.m_nativPath.getIndexFromTail(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public boolean containsNode(SoNode soNode) {
            return this.m_nativPath.containsNode(SoPath.this.getNativeResourceHandle(), soNode.getNativeResourceHandle());
        }

        @Override
        public int getInstanceIndex(int n) {
            return this.m_nativPath.getInstanceIndex(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getInstanceIndexFromTail(int n) {
            return this.m_nativPath.getInstanceIndexFromTail(SoPath.this.getNativeResourceHandle(), n);
        }
    }

    private class regularPath
    extends InnerPath
    implements SoGeneralPath {
        private SoPathDotRegularPath m_nativPath;

        private regularPath() {
            this.m_nativPath = new SoPathDotRegularPath();
        }

        @Override
        SoPathDotInnerPath getNativPath() {
            return this.m_nativPath;
        }

        @Override
        public boolean containsNode(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return this.m_nativPath.containsNodeClass(SoPath.this.getNativeResourceHandle(), clazz.getName());
        }

        @Override
        public SoNode getNode(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return ObjectManager.getManagedObjectFor(SoNode.class, this.m_nativPath.getNodeClass(SoPath.this.getNativeResourceHandle(), clazz.getName()));
        }

        @Override
        public int getIndex(Class clazz) throws IllegalArgumentException {
            if (!SoNode.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("argument class must inherit from SoNode");
            }
            return this.m_nativPath.getIndexClass(SoPath.this.getNativeResourceHandle(), clazz.getName());
        }

        @Override
        public void append(int n) {
            this.m_nativPath.append(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public void append(SoNode soNode) {
            this.m_nativPath.appendNode(SoPath.this.getNativeResourceHandle(), soNode.getNativeResourceHandle());
        }

        @Override
        public void push(int n) {
            this.m_nativPath.push(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getIndex(int n) {
            return this.m_nativPath.getIndex(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getIndexFromTail(int n) {
            return this.m_nativPath.getIndexFromTail(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public boolean containsNode(SoNode soNode) {
            return this.m_nativPath.containsNode(SoPath.this.getNativeResourceHandle(), soNode.getNativeResourceHandle());
        }

        @Override
        public int getInstanceIndex(int n) {
            return this.m_nativPath.getInstanceIndex(SoPath.this.getNativeResourceHandle(), n);
        }

        @Override
        public int getInstanceIndexFromTail(int n) {
            return this.m_nativPath.getInstanceIndexFromTail(SoPath.this.getNativeResourceHandle(), n);
        }
    }

    private class nodekitPath
    extends InnerPath
    implements SoNodeKitPath {
        private SoPathDotNodekitPath m_nativPath;

        private nodekitPath() {
            this.m_nativPath = new SoPathDotNodekitPath();
        }

        @Override
        SoPathDotInnerPath getNativPath() {
            return this.m_nativPath;
        }

        @Override
        public void append(SoBaseKit soBaseKit) {
            this.m_nativPath.appendBaseKit(SoPath.this.getNativeResourceHandle(), soBaseKit.getNativeResourceHandle());
        }

        @Override
        public boolean containsNode(SoBaseKit soBaseKit) {
            return this.m_nativPath.containsBaseKit(SoPath.this.getNativeResourceHandle(), soBaseKit.getNativeResourceHandle());
        }
    }

    private abstract class InnerPath {
        private InnerPath() {
        }

        abstract SoPathDotInnerPath getNativPath();

        public void setHead(SoNode soNode) {
            this.getNativPath().setHead(SoPath.this.getNativeResourceHandle(), soNode.getNativeResourceHandle());
        }

        public SoNode getHead() {
            return ObjectManager.getManagedObjectFor(SoNode.class, this.getNativPath().getHead(SoPath.this.getNativeResourceHandle()));
        }

        public void append(SoPath soPath) {
            this.getNativPath().appendPath(SoPath.this.getNativeResourceHandle(), soPath.getNativeResourceHandle());
        }

        public void pop() {
            this.getNativPath().pop(SoPath.this.getNativeResourceHandle());
        }

        public int getLength() {
            return this.getNativPath().getLength(SoPath.this.getNativeResourceHandle());
        }

        public void truncate(int n) {
            this.getNativPath().truncate(SoPath.this.getNativeResourceHandle(), n);
        }

        public boolean containsPath(SoPath soPath) {
            return this.getNativPath().containsPath(SoPath.this.getNativeResourceHandle(), soPath.getNativeResourceHandle());
        }

        public int findFork(SoPath soPath) {
            return this.getNativPath().findFork(SoPath.this.getNativeResourceHandle(), soPath.getNativeResourceHandle());
        }

        public SoNode getTail() {
            return ObjectManager.getManagedObjectFor(SoNode.class, this.getNativPath().getTail(SoPath.this.getNativeResourceHandle()));
        }

        public SoNode getNode(int n) {
            return ObjectManager.getManagedObjectFor(SoNode.class, this.getNativPath().getNode(SoPath.this.getNativeResourceHandle(), n));
        }

        public SoNode getNodeFromTail(int n) {
            return ObjectManager.getManagedObjectFor(SoNode.class, this.getNativPath().getNodeFromTail(SoPath.this.getNativeResourceHandle(), n));
        }

        public SoPath copy(int n) {
            return ObjectManager.getManagedObjectFor(SoPath.class, this.getNativPath().copy(SoPath.this.getNativeResourceHandle(), n, 0));
        }

        public SoPath copy(int n, int n2) {
            return ObjectManager.getManagedObjectFor(SoPath.class, this.getNativPath().copy(SoPath.this.getNativeResourceHandle(), n, n2));
        }
    }
}

