/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.antialiasing.SiAntialiasingEventListener;
import com.openinventor.inventor.antialiasing.SoAntialiasingParameters;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.helpers.SbGLShareContext;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import java.util.Hashtable;

public class SoSceneManager
extends Inventor {
    private SoAntialiasingParameters m_advancedParameters_setAntialiasing;
    private SiAntialiasingEventListener m_listener_setAntialiasingEventListener;
    private SoHandleEventAction m_hea_setHandleEventAction;
    private SoGLRenderAction m_ra_setGLRenderAction;
    private SoNode m_sceneGraph;
    private boolean m_nativeRenderCallbackInitialized = false;
    private static Hashtable<Long, Runnable> s_renderTasks = new Hashtable();
    private boolean m_nativeAbortRenderCallbackInitialized = false;
    private static Hashtable<Long, AbortRenderTask> s_abortRenderTasks = new Hashtable();
    private boolean m_isFloatingPointRendering;
    private int m_floatingPointRenderingPrecision;

    private void onSetSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
    }

    public void setRenderTask(Runnable runnable) {
        SoSceneManager.delRenderTask(this.getNativeResourceHandle());
        if (runnable != null) {
            SoSceneManager.addRenderTask(runnable, this.getNativeResourceHandle());
            if (!this.m_nativeRenderCallbackInitialized) {
                SoSceneManager.initNativeRenderCallback(this.getNativeResourceHandle());
                this.m_nativeRenderCallbackInitialized = true;
            }
        }
    }

    private static native void initNativeRenderCallback(long var0);

    private static void addRenderTask(Runnable runnable, long l) {
        s_renderTasks.put(l, runnable);
    }

    private static void delRenderTask(long l) {
        s_renderTasks.remove(l);
    }

    private static void invokeRenderTask(long l) {
        Runnable runnable = s_renderTasks.get(l);
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setAbortRenderTask(AbortRenderTask abortRenderTask) {
        SoSceneManager.removeAbortRenderTask(this.getNativeResourceHandle());
        if (abortRenderTask != null) {
            SoSceneManager.setAbortRenderTask(abortRenderTask, this.getNativeResourceHandle());
            if (!this.m_nativeAbortRenderCallbackInitialized) {
                SoSceneManager.initNativeAbortRenderCallback(this.getNativeResourceHandle());
                this.m_nativeAbortRenderCallbackInitialized = true;
            }
        }
    }

    private static native void initNativeAbortRenderCallback(long var0);

    private static void setAbortRenderTask(AbortRenderTask abortRenderTask, long l) {
        s_abortRenderTasks.put(l, abortRenderTask);
    }

    private static void removeAbortRenderTask(long l) {
        s_abortRenderTasks.remove(l);
    }

    private static boolean invokeAbortRenderTask(long l, long l2) {
        AbortRenderTask abortRenderTask = s_abortRenderTasks.get(l);
        if (abortRenderTask == null) {
            return false;
        }
        return abortRenderTask.run(ObjectManager.getManagedObjectFor(SoAction.class, l2));
    }

    public void scheduleForcedRedraw() {
        SoSceneManager.scheduleForcedRedrawImpl(this.getNativeResourceHandle());
    }

    private static native void scheduleForcedRedrawImpl(long var0);

    public void setFloatingColorBuffer(boolean bl, int n) {
        this.m_isFloatingPointRendering = bl;
        this.m_floatingPointRenderingPrecision = n;
        SoSceneManager.setFloatingColorBufferImpl(this.getNativeResourceHandle(), bl, n);
    }

    private static native void setFloatingColorBufferImpl(long var0, boolean var2, int var3);

    public int getFloatingPointRenderingPrecision() {
        return this.m_floatingPointRenderingPrecision;
    }

    public void updateRealTimeSensor() {
        SoSceneManager.updateRealTimeSensorImpl(this.getNativeResourceHandle());
    }

    private static native void updateRealTimeSensorImpl(long var0);

    private static native void setBackgroundColorImpl(long var0, float[] var2);

    private static native float getStillSuperSamplingQualityImpl(long var0);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native void setStillSuperSamplingImpl(long var0, float var2, float var3);

    private static native void setBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native void setShareContextImpl(long var0, long var2, boolean var4);

    private static native void getBackgroundColorImpl(long var0, float[] var2);

    private static native void setAntialiasingImpl1(long var0, long var2);

    private static native void setOriginImpl(long var0, short[] var2);

    private static native float getAntialiasingQualityImpl(long var0);

    private static native void getOriginImpl(long var0, short[] var2);

    private static native float getStillSuperSamplingDelayImpl(long var0);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native void setAntialiasingImpl(long var0, float var2, int var3);

    private static native void setAutoInteractiveModeImpl(long var0, boolean var2);

    private static native boolean isRGBModeImpl(long var0);

    private static native boolean isAutoInteractiveModeImpl(long var0);

    private static native void setClearDepthImpl(long var0, float var2);

    private static native void activateImpl(long var0);

    private static native float getClearDepthImpl(long var0);

    private static native void deactivateImpl(long var0);

    private static native void setRedrawPriorityImpl(long var0, int var2);

    private static native void getBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native int getRedrawPriorityImpl(long var0);

    private static native void setBackgroundIndexImpl(long var0, int var2);

    private static native void setRGBModeImpl(long var0, boolean var2);

    private static native int getBackgroundIndexImpl(long var0);

    private static native boolean isAutoRedrawImpl(long var0);

    private static native void setAntialiasingImpl2(long var0, boolean var2, int var3);

    private static native void renderImpl1(long var0, boolean var2, boolean var3);

    private static native void reinitializeImpl(long var0);

    private static native long getGLRenderActionImpl(long var0);

    private static native boolean processEventImpl(long var0, long var2);

    private static native void renderImpl(long var0);

    private static native boolean isRealTimeUpdateEnabledImpl();

    private static native long ctorImpl(int var0);

    private static native void setInteractiveImpl(long var0, boolean var2);

    private static native int getDefaultRedrawPriorityImpl();

    private static native void enableRealTimeUpdateImpl(boolean var0);

    private static native long ctorImpl1();

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native void getWindowSizeImpl(long var0, short[] var2);

    private static native void setAntialiasingEventListenerImpl(long var0, long var2);

    private static native void setWindowSizeImpl(long var0, short[] var2, float var3);

    private static native int getAntialiasingModeImpl(long var0);

    private static native void getSizeImpl(long var0, short[] var2);

    private static native long getAntialiasingParametersImpl(long var0);

    private static native void setSizeImpl(long var0, short[] var2, float var3);

    private static native void scheduleRedrawImpl(long var0);

    private static native void setSceneGraphImpl(long var0, long var2);

    private static native long getHandleEventActionImpl(long var0);

    private static native void setHandleEventActionImpl(long var0, long var2);

    private static native long getAntialiasingEventListenerImpl(long var0);

    private static native long getSceneGraphImpl(long var0);

    protected SoSceneManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void setShareContext(SbGLShareContext sbGLShareContext) {
        this.setShareContext(sbGLShareContext, true);
    }

    public void setAntialiasing(float f) {
        this.setAntialiasing(f, AntialiasingModes.valueOf(AntialiasingModes.AUTO.getValue()));
    }

    @Deprecated(since="10.1.0.0")
    public void render(boolean bl) {
        this.render(bl, true);
    }

    public void setWindowSize(SbVec2s sbVec2s) {
        this.setWindowSize(sbVec2s, 1.0f);
    }

    public void setSize(SbVec2s sbVec2s) {
        this.setSize(sbVec2s, 1.0f);
    }

    public void scheduleRedraw() {
        SoSceneManager.scheduleRedrawImpl(this.getNativeResourceHandle());
    }

    public SoGLRenderAction getGLRenderAction() {
        return ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoSceneManager.getGLRenderActionImpl(this.getNativeResourceHandle()));
    }

    @Deprecated(since="9.1.0.0")
    public void setAntialiasing(boolean bl, int n) {
        SoSceneManager.setAntialiasingImpl2(this.getNativeResourceHandle(), bl, n);
    }

    public void reinitialize() {
        SoSceneManager.reinitializeImpl(this.getNativeResourceHandle());
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_ra_setGLRenderAction = soGLRenderAction;
        SoSceneManager.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoNode getSceneGraph() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoSceneManager.getSceneGraphImpl(this.getNativeResourceHandle()));
    }

    public void setHandleEventAction(SoHandleEventAction soHandleEventAction) {
        this.m_hea_setHandleEventAction = soHandleEventAction;
        SoSceneManager.setHandleEventActionImpl(this.getNativeResourceHandle(), soHandleEventAction != null ? soHandleEventAction.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setSceneGraph(SoNode soNode) {
        this.onSetSceneGraph(soNode);
        SoSceneManager.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoHandleEventAction getHandleEventAction() {
        return ObjectManager.getManagedObjectFor(SoHandleEventAction.class, SoSceneManager.getHandleEventActionImpl(this.getNativeResourceHandle()));
    }

    public static boolean isRealTimeUpdateEnabled() {
        return SoSceneManager.isRealTimeUpdateEnabledImpl();
    }

    public static void enableRealTimeUpdate(boolean bl) {
        SoSceneManager.enableRealTimeUpdateImpl(bl);
    }

    @Deprecated(since="2024.2")
    public SoSceneManager(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSceneManager.ctorImpl(n));
    }

    public SoSceneManager() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSceneManager.ctorImpl1());
    }

    public void render() {
        SoSceneManager.renderImpl(this.getNativeResourceHandle());
    }

    public boolean processEvent(SoEvent soEvent) {
        return SoSceneManager.processEventImpl(this.getNativeResourceHandle(), soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static int getDefaultRedrawPriority() {
        return SoSceneManager.getDefaultRedrawPriorityImpl();
    }

    @Deprecated(since="10.1.0.0")
    public void render(boolean bl, boolean bl2) {
        SoSceneManager.renderImpl1(this.getNativeResourceHandle(), bl, bl2);
    }

    public void setRedrawPriority(int n) {
        SoSceneManager.setRedrawPriorityImpl(this.getNativeResourceHandle(), n);
    }

    public void setBackgroundIndex(int n) {
        SoSceneManager.setBackgroundIndexImpl(this.getNativeResourceHandle(), n);
    }

    public boolean isAutoRedraw() {
        return SoSceneManager.isAutoRedrawImpl(this.getNativeResourceHandle());
    }

    public int getBackgroundIndex() {
        return SoSceneManager.getBackgroundIndexImpl(this.getNativeResourceHandle());
    }

    public int getRedrawPriority() {
        return SoSceneManager.getRedrawPriorityImpl(this.getNativeResourceHandle());
    }

    public void setBackgroundColorRGBA(SbColorRGBA sbColorRGBA) {
        SoSceneManager.setBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
    }

    public void setStillSuperSampling(float f, float f2) {
        SoSceneManager.setStillSuperSamplingImpl(this.getNativeResourceHandle(), f, f2);
    }

    public SbColorRGBA getBackgroundColorRGBA() {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        SoSceneManager.getBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA.array);
        return sbColorRGBA;
    }

    public void setShareContext(SbGLShareContext sbGLShareContext, boolean bl) {
        SoSceneManager.setShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext != null ? sbGLShareContext.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
    }

    public float getClearDepth() {
        return SoSceneManager.getClearDepthImpl(this.getNativeResourceHandle());
    }

    public void setAutoInteractiveMode(boolean bl) {
        SoSceneManager.setAutoInteractiveModeImpl(this.getNativeResourceHandle(), bl);
    }

    public void activate() {
        SoSceneManager.activateImpl(this.getNativeResourceHandle());
    }

    public void deactivate() {
        SoSceneManager.deactivateImpl(this.getNativeResourceHandle());
    }

    public void setClearDepth(float f) {
        SoSceneManager.setClearDepthImpl(this.getNativeResourceHandle(), f);
    }

    public void setInteractive(boolean bl) {
        SoSceneManager.setInteractiveImpl(this.getNativeResourceHandle(), bl);
    }

    public void setRGBMode(boolean bl) {
        SoSceneManager.setRGBModeImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isAutoInteractiveMode() {
        return SoSceneManager.isAutoInteractiveModeImpl(this.getNativeResourceHandle());
    }

    public boolean isRGBMode() {
        return SoSceneManager.isRGBModeImpl(this.getNativeResourceHandle());
    }

    public SbColor getBackgroundColor() {
        SbColor sbColor = new SbColor();
        SoSceneManager.getBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        return sbColor;
    }

    public SbVec2s getSize() {
        SbVec2s sbVec2s = new SbVec2s();
        SoSceneManager.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public AntialiasingModes getAntialiasingMode() {
        return IntegerValuedEnumHelper.fromIntValue(AntialiasingModes.class, SoSceneManager.getAntialiasingModeImpl(this.getNativeResourceHandle()));
    }

    public void setOrigin(SbVec2s sbVec2s) {
        SoSceneManager.setOriginImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
    }

    public SoAntialiasingParameters getAntialiasingParameters() {
        return ObjectManager.getManagedObjectFor(SoAntialiasingParameters.class, SoSceneManager.getAntialiasingParametersImpl(this.getNativeResourceHandle()));
    }

    public void setSize(SbVec2s sbVec2s, float f) {
        SoSceneManager.setSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, f);
    }

    public SiAntialiasingEventListener getAntialiasingEventListener() {
        return ObjectManager.getManagedObjectFor(SiAntialiasingEventListener.class, SoSceneManager.getAntialiasingEventListenerImpl(this.getNativeResourceHandle()));
    }

    public void setWindowSize(SbVec2s sbVec2s, float f) {
        SoSceneManager.setWindowSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, f);
    }

    public void setAntialiasingEventListener(SiAntialiasingEventListener siAntialiasingEventListener) {
        this.m_listener_setAntialiasingEventListener = siAntialiasingEventListener;
        SoSceneManager.setAntialiasingEventListenerImpl(this.getNativeResourceHandle(), siAntialiasingEventListener != null ? siAntialiasingEventListener.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbVec2s getWindowSize() {
        SbVec2s sbVec2s = new SbVec2s();
        SoSceneManager.getWindowSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public float getStillSuperSamplingDelay() {
        return SoSceneManager.getStillSuperSamplingDelayImpl(this.getNativeResourceHandle());
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        SoSceneManager.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        return sbViewportRegion;
    }

    public float getStillSuperSamplingQuality() {
        return SoSceneManager.getStillSuperSamplingQualityImpl(this.getNativeResourceHandle());
    }

    public void setBackgroundColor(SbColor sbColor) {
        SoSceneManager.setBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
    }

    public void setAntialiasing(float f, AntialiasingModes antialiasingModes) {
        SoSceneManager.setAntialiasingImpl(this.getNativeResourceHandle(), f, antialiasingModes.getValue());
    }

    public SbVec2s getOrigin() {
        SbVec2s sbVec2s = new SbVec2s();
        SoSceneManager.getOriginImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public float getAntialiasingQuality() {
        return SoSceneManager.getAntialiasingQualityImpl(this.getNativeResourceHandle());
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        SoSceneManager.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setAntialiasing(SoAntialiasingParameters soAntialiasingParameters) {
        this.m_advancedParameters_setAntialiasing = soAntialiasingParameters;
        SoSceneManager.setAntialiasingImpl1(this.getNativeResourceHandle(), soAntialiasingParameters != null ? soAntialiasingParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static interface AbortRenderTask {
        public boolean run(SoAction var1);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum AntialiasingModes implements IntegerValuedEnum
    {
        AUTO(AntialiasingModes.getAUTO()),
        FXAA(AntialiasingModes.getFXAA()),
        SMAA(AntialiasingModes.getSMAA()),
        FSAA(AntialiasingModes.getFSAA()),
        SUPERSAMPLING(AntialiasingModes.getSUPERSAMPLING()),
        ACCUM_BUFFERS(AntialiasingModes.getACCUMBUFFERS()),
        NO_ANTIALIASING(AntialiasingModes.getNOANTIALIASING());

        private int value;

        private static native int getACCUMBUFFERSNative();

        private static int getSUPERSAMPLING() {
            JniInitializer.checkInit();
            return AntialiasingModes.getSUPERSAMPLINGNative();
        }

        private static native int getSUPERSAMPLINGNative();

        private static int getACCUMBUFFERS() {
            JniInitializer.checkInit();
            return AntialiasingModes.getACCUMBUFFERSNative();
        }

        private AntialiasingModes(int n2) {
            this.value = n2;
        }

        private static int getNOANTIALIASING() {
            JniInitializer.checkInit();
            return AntialiasingModes.getNOANTIALIASINGNative();
        }

        private static native int getNOANTIALIASINGNative();

        private static int getFSAA() {
            JniInitializer.checkInit();
            return AntialiasingModes.getFSAANative();
        }

        private static native int getFXAANative();

        private static int getAUTO() {
            JniInitializer.checkInit();
            return AntialiasingModes.getAUTONative();
        }

        private static native int getAUTONative();

        private static int getFXAA() {
            JniInitializer.checkInit();
            return AntialiasingModes.getFXAANative();
        }

        private static native int getFSAANative();

        private static int getSMAA() {
            JniInitializer.checkInit();
            return AntialiasingModes.getSMAANative();
        }

        private static native int getSMAANative();

        public static AntialiasingModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AntialiasingModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

