/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.algorithms;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.algorithms.SoArithmetic;
import com.openinventor.inventor.algorithms.SoConversion;
import com.openinventor.inventor.algorithms.SoConvolution;
import com.openinventor.inventor.algorithms.SoDataExtract;
import com.openinventor.inventor.algorithms.SoSeismic;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoDeviceContext;
import com.openinventor.inventor.internal.JniInitializer;

public class SoAlgorithms
extends Inventor {
    private static native long createContextImpl(long var0);

    private static native long loadAlgorithmsModuleImpl(String var0);

    private static native long createDataExtractInterfaceImpl(long var0);

    private static native long ctorImpl();

    private static native long createBufferObjectImpl(long var0);

    private static native boolean unloadAlgorithmsModuleImpl(String var0);

    private static native void finishImpl();

    private static native void initImpl();

    private static native long createConvolutionInterfaceImpl(long var0);

    private static native long createArithmeticInterfaceImpl(long var0);

    private static native long createSeismicInterfaceImpl(long var0);

    private static native boolean isInitializedImpl();

    private static native long createConversionInterfaceImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoAlgorithms(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoConvolution createConvolutionInterface() {
        return ObjectManager.getManagedObjectFor(SoConvolution.class, SoAlgorithms.createConvolutionInterfaceImpl(this.getNativeResourceHandle()));
    }

    public static boolean isInitialized() {
        return SoAlgorithms.isInitializedImpl();
    }

    public static void init() {
        SoAlgorithms.initImpl();
    }

    public SoBufferObject createBufferObject() {
        return ObjectManager.getManagedObjectFor(SoBufferObject.class, SoAlgorithms.createBufferObjectImpl(this.getNativeResourceHandle()));
    }

    public SoArithmetic createArithmeticInterface() {
        return ObjectManager.getManagedObjectFor(SoArithmetic.class, SoAlgorithms.createArithmeticInterfaceImpl(this.getNativeResourceHandle()));
    }

    public SoConversion createConversionInterface() {
        return ObjectManager.getManagedObjectFor(SoConversion.class, SoAlgorithms.createConversionInterfaceImpl(this.getNativeResourceHandle()));
    }

    public static boolean unloadAlgorithmsModule(String string) {
        return SoAlgorithms.unloadAlgorithmsModuleImpl(string);
    }

    public SoDeviceContext createContext() {
        return ObjectManager.getManagedObjectFor(SoDeviceContext.class, SoAlgorithms.createContextImpl(this.getNativeResourceHandle()));
    }

    public SoAlgorithms() {
        this(Inventor.ConstructorCommand.CreateInstance, SoAlgorithms.ctorImpl());
    }

    public SoDataExtract createDataExtractInterface() {
        return ObjectManager.getManagedObjectFor(SoDataExtract.class, SoAlgorithms.createDataExtractInterfaceImpl(this.getNativeResourceHandle()));
    }

    public static void finish() {
        SoAlgorithms.finishImpl();
    }

    public SoSeismic createSeismicInterface() {
        return ObjectManager.getManagedObjectFor(SoSeismic.class, SoAlgorithms.createSeismicInterfaceImpl(this.getNativeResourceHandle()));
    }

    public static SoAlgorithms loadAlgorithmsModule(String string) {
        return ObjectManager.getManagedObjectFor(SoAlgorithms.class, SoAlgorithms.loadAlgorithmsModuleImpl(string));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

