/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.elements.SoTangentBindingElement;
import com.openinventor.inventor.misc.SoState;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoTangentCache
extends SoCache {
    private static native long getTangentsImpl(long var0);

    private static native void setImpl(long var0, int var2, Object[] var3, int var4, int var5);

    private static native Object getDirectTangentsImpl(long var0);

    private static native int getNumImpl(long var0);

    private static native int getTangentBindingImpl(long var0);

    private static native int getStartIndexImpl(long var0);

    private static native long ctorImpl(long var0);

    protected SoTangentCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void set(SbVec3f[] sbVec3fArray, SoTangentBindingElement.Bindings bindings) {
        this.set(sbVec3fArray, bindings, 0);
    }

    public FloatBuffer getDirectTangents() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoTangentCache.getDirectTangentsImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public int getStartIndex() {
        return SoTangentCache.getStartIndexImpl(this.getNativeResourceHandle());
    }

    public SoTangentCache(SoState soState) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTangentCache.ctorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SbVec3f[] getTangents() {
        long l = Inventor.ZeroHandle;
        l = SoTangentCache.getTangentsImpl(this.getNativeResourceHandle());
        return SbVec3f.toArray(l, this.getNum());
    }

    public int getNum() {
        return SoTangentCache.getNumImpl(this.getNativeResourceHandle());
    }

    public SoTangentBindingElement.Bindings getTangentBinding() {
        return IntegerValuedEnumHelper.fromIntValue(SoTangentBindingElement.Bindings.class, SoTangentCache.getTangentBindingImpl(this.getNativeResourceHandle()));
    }

    public void set(SbVec3f[] sbVec3fArray, SoTangentBindingElement.Bindings bindings, int n) {
        SoTangentCache.setImpl(this.getNativeResourceHandle(), sbVec3fArray != null ? sbVec3fArray.length : 0, sbVec3fArray, bindings.getValue(), n);
    }
}

