/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.devices.SoDeviceContext;
import com.openinventor.inventor.internal.JniInitializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoBufferObject
extends Inventor
implements SafeDisposable {
    public static final long SO_BUFFER_SIZE_ALL = -1L;

    private static native void unmapImpl1(long var0, long var2);

    private static native void memcpyImpl(long var0, long var2, long var4, long var6, long var8);

    private static native long getMappedBufferObjectPositionImpl(long var0);

    private static native Object mapImpl(long var0, int var2, long var3, long var5);

    private static native void unmapImpl(long var0);

    private static native long createInstanceImpl(long var0);

    private static native long getMappedBufferObjectImpl(long var0);

    private static native int getMappedBufferObjectAccessModeImpl(long var0);

    private static native long getMappedBufferObjectSizeImpl(long var0);

    private static native void clearInstanceImpl(long var0);

    private static native long getContextImpl(long var0);

    private static native void unlockBufferImpl(long var0);

    private static native boolean setSizeImpl(long var0, long var2);

    private static native void lockBufferImpl(long var0);

    private static native void mapImpl1(long var0, long var2, int var4, long var5, long var7);

    private static native long getSizeImpl(long var0);

    protected SoBufferObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    static native String getClassTypeId();

    public void map(SoBufferObject soBufferObject, AccessModes accessModes) {
        this.map(soBufferObject, accessModes, 0L, -1L);
    }

    public void map(SoBufferObject soBufferObject, AccessModes accessModes, long l) {
        this.map(soBufferObject, accessModes, l, -1L);
    }

    public ByteBuffer map(AccessModes accessModes, long l) {
        return this.map(accessModes, l, -1L);
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public ByteBuffer map(AccessModes accessModes) {
        return this.map(accessModes, 0L, -1L);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    public void memcpy(SoBufferObject soBufferObject, long l, long l2) {
        this.memcpy(soBufferObject, l, l2, -1L);
    }

    public void memcpy(SoBufferObject soBufferObject) {
        this.memcpy(soBufferObject, 0L, 0L, -1L);
    }

    public void memcpy(SoBufferObject soBufferObject, long l) {
        this.memcpy(soBufferObject, l, 0L, -1L);
    }

    public AccessModes getMappedBufferObjectAccessMode() {
        return IntegerValuedEnumHelper.fromIntValue(AccessModes.class, SoBufferObject.getMappedBufferObjectAccessModeImpl(this.getNativeResourceHandle()));
    }

    public SoBufferObject getMappedBufferObject() {
        return ObjectManager.getManagedObjectFor(SoBufferObject.class, SoBufferObject.getMappedBufferObjectImpl(this.getNativeResourceHandle()));
    }

    public SoDeviceContext getContext() {
        return ObjectManager.getManagedObjectFor(SoDeviceContext.class, SoBufferObject.getContextImpl(this.getNativeResourceHandle()));
    }

    public void unmap(SoBufferObject soBufferObject) {
        SoBufferObject.unmapImpl1(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public long getMappedBufferObjectSize() {
        return SoBufferObject.getMappedBufferObjectSizeImpl(this.getNativeResourceHandle());
    }

    public long getMappedBufferObjectPosition() {
        return SoBufferObject.getMappedBufferObjectPositionImpl(this.getNativeResourceHandle());
    }

    public void clearInstance() {
        SoBufferObject.clearInstanceImpl(this.getNativeResourceHandle());
    }

    public void map(SoBufferObject soBufferObject, AccessModes accessModes, long l, long l2) {
        SoBufferObject.mapImpl1(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, accessModes.getValue(), l, l2);
    }

    public void unmap() {
        SoBufferObject.unmapImpl(this.getNativeResourceHandle());
    }

    public void memcpy(SoBufferObject soBufferObject, long l, long l2, long l3) {
        SoBufferObject.memcpyImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2, l3);
    }

    public SoBufferObject createInstance() {
        return ObjectManager.getManagedObjectFor(SoBufferObject.class, SoBufferObject.createInstanceImpl(this.getNativeResourceHandle()));
    }

    public ByteBuffer map(AccessModes accessModes, long l, long l2) {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoBufferObject.mapImpl(this.getNativeResourceHandle(), accessModes.getValue(), l, l2);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public void unlockBuffer() {
        SoBufferObject.unlockBufferImpl(this.getNativeResourceHandle());
    }

    public void lockBuffer() {
        SoBufferObject.lockBufferImpl(this.getNativeResourceHandle());
    }

    public long getSize() {
        return SoBufferObject.getSizeImpl(this.getNativeResourceHandle());
    }

    public boolean setSize(long l) {
        return SoBufferObject.setSizeImpl(this.getNativeResourceHandle(), l);
    }

    public static enum AccessModes implements IntegerValuedEnum
    {
        READ_ONLY(AccessModes.getREADONLY()),
        SET(AccessModes.getSET()),
        READ_WRITE(AccessModes.getREADWRITE());

        private int value;

        private static native int getREADWRITENative();

        private static int getREADWRITE() {
            JniInitializer.checkInit();
            return AccessModes.getREADWRITENative();
        }

        private AccessModes(int n2) {
            this.value = n2;
        }

        private static int getSET() {
            JniInitializer.checkInit();
            return AccessModes.getSETNative();
        }

        private static native int getREADONLYNative();

        private static int getREADONLY() {
            JniInitializer.checkInit();
            return AccessModes.getREADONLYNative();
        }

        private static native int getSETNative();

        public static AccessModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AccessModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

