/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoDevice;
import com.openinventor.inventor.internal.JniInitializer;

public class SoCpuDevice
extends SoDevice {
    private static native long findFirstAvailableDeviceImpl();

    private static native boolean hasMMXImpl(long var0);

    private static native boolean isActiveImpl(long var0);

    private static native boolean hasSSEImpl(long var0);

    private static native long getDeviceImpl(int var0);

    private static native int getSSELevelImpl(long var0);

    private static native int getDevicesCountImpl();

    private static native int getCacheSizeImpl(long var0, int var2);

    private static native int getArchitectureImpl(long var0);

    protected SoCpuDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static SoCpuDevice getDevice() {
        return SoCpuDevice.getDevice(0);
    }

    public int getSSELevel() {
        return SoCpuDevice.getSSELevelImpl(this.getNativeResourceHandle());
    }

    public static int getDevicesCount() {
        return SoCpuDevice.getDevicesCountImpl();
    }

    public int getCacheSize(int n) {
        return SoCpuDevice.getCacheSizeImpl(this.getNativeResourceHandle(), n);
    }

    public static SoCpuDevice getDevice(int n) {
        return ObjectManager.getManagedObjectFor(SoCpuDevice.class, SoCpuDevice.getDeviceImpl(n));
    }

    public static SoCpuDevice findFirstAvailableDevice() {
        return ObjectManager.getManagedObjectFor(SoCpuDevice.class, SoCpuDevice.findFirstAvailableDeviceImpl());
    }

    public boolean hasSSE() {
        return SoCpuDevice.hasSSEImpl(this.getNativeResourceHandle());
    }

    public boolean hasMMX() {
        return SoCpuDevice.hasMMXImpl(this.getNativeResourceHandle());
    }

    public ProcessorArchitectures getArchitecture() {
        return IntegerValuedEnumHelper.fromIntValue(ProcessorArchitectures.class, SoCpuDevice.getArchitectureImpl(this.getNativeResourceHandle()));
    }

    public boolean isActive() {
        return SoCpuDevice.isActiveImpl(this.getNativeResourceHandle());
    }

    public static enum ProcessorArchitectures implements IntegerValuedEnum
    {
        X86_64(ProcessorArchitectures.getX8664()),
        X86_32(ProcessorArchitectures.getX8632()),
        IA64(ProcessorArchitectures.getIA64()),
        PPC_32(ProcessorArchitectures.getPPC32()),
        PPC_64(ProcessorArchitectures.getPPC64()),
        UNKNOWN(ProcessorArchitectures.getUNKNOWN());

        private int value;

        private static int getPPC64() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getPPC64Native();
        }

        private static native int getPPC64Native();

        private static int getPPC32() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getPPC32Native();
        }

        private ProcessorArchitectures(int n2) {
            this.value = n2;
        }

        private static int getUNKNOWN() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getUNKNOWNNative();
        }

        private static native int getUNKNOWNNative();

        private static native int getPPC32Native();

        private static native int getX8632Native();

        private static int getX8664() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getX8664Native();
        }

        private static native int getX8664Native();

        private static int getIA64() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getIA64Native();
        }

        private static native int getIA64Native();

        private static int getX8632() {
            JniInitializer.checkInit();
            return ProcessorArchitectures.getX8632Native();
        }

        public static ProcessorArchitectures valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ProcessorArchitectures.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

