/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.internal.JniInitializer;

public class SoDevice
extends Inventor {
    private static native String getDeviceNameImpl(long var0);

    private static native long getDeviceImpl(int var0);

    private static native int getLogicalUnitsImpl(long var0);

    private static native String getDriverVersionImpl(long var0);

    private static native int getDevicesCountImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static int getDevicesCount() {
        return SoDevice.getDevicesCountImpl();
    }

    public String getDeviceName() {
        return SoDevice.getDeviceNameImpl(this.getNativeResourceHandle());
    }

    public String getDriverVersion() {
        return SoDevice.getDriverVersionImpl(this.getNativeResourceHandle());
    }

    public int getLogicalUnits() {
        return SoDevice.getLogicalUnitsImpl(this.getNativeResourceHandle());
    }

    public static SoDevice getDevice(int n) {
        return ObjectManager.getManagedObjectFor(SoDevice.class, SoDevice.getDeviceImpl(n));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

