/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.devices.SoGLDevice;
import com.openinventor.inventor.internal.JniInitializer;

public class SoGLScreenDevice
extends Inventor {
    private static native void getResolutionImpl(long var0, int[] var2);

    private static native int getColorDepthImpl(long var0);

    private static native void getPhysicalSizeImpl(long var0, float[] var2);

    private static native String getNameImpl(long var0);

    private static native long getGLDeviceImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoGLScreenDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getColorDepth() {
        return SoGLScreenDevice.getColorDepthImpl(this.getNativeResourceHandle());
    }

    public SbVec2f getPhysicalSize() {
        SbVec2f sbVec2f = new SbVec2f();
        SoGLScreenDevice.getPhysicalSizeImpl(this.getNativeResourceHandle(), sbVec2f.array);
        return sbVec2f;
    }

    public SbVec2i32 getResolution() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        SoGLScreenDevice.getResolutionImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        return sbVec2i32;
    }

    public SoGLDevice getGLDevice() {
        return ObjectManager.getManagedObjectFor(SoGLDevice.class, SoGLScreenDevice.getGLDeviceImpl(this.getNativeResourceHandle()));
    }

    public String getName() {
        return SoGLScreenDevice.getNameImpl(this.getNativeResourceHandle());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

