/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.SoState;

public abstract class SoElement
extends Inventor {
    public static <E extends SoElement> int getClassStackIndex(Class<E> clazz) {
        return ElementManager.getClassStackIndex(clazz);
    }

    protected static <E extends SoElement> E getElement(SoState soState, Class<E> clazz) {
        return (E)((SoElement)clazz.cast(SoElement.getElement(soState, clazz, SoElement.getClassStackIndex(clazz))));
    }

    protected static <E extends SoElement> E getConstElement(SoState soState, Class<E> clazz) {
        return (E)((SoElement)clazz.cast(SoElement.getConstElement(soState, clazz, SoElement.getClassStackIndex(clazz))));
    }

    private static native boolean isPoppedImpl(long var0);

    private static native long getNextInStackImpl(long var0);

    private static native long copyMatchInfoImpl(long var0);

    private static native long getConstElementImpl(long var0, String var2, int var3);

    private static native boolean matchesImpl(long var0, long var2);

    private static native void setPoppedImpl(long var0, boolean var2);

    private static native void setTypeIdImpl(long var0, String var2);

    private static native void captureThisImpl(long var0, long var2);

    private static native void captureImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native long getNextFreeImpl(long var0);

    private static native void initImpl(long var0, long var2);

    private static native void popImpl(long var0, long var2, long var4);

    private static native void pushImpl(long var0, long var2);

    private static native int[] initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5, int var6);

    private static native void nativeDerivedClassInit();

    private static native long getElementImpl(long var0, String var2, int var3);

    private static native long getElementImpl1(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated(since="9.0.0.0")
    protected static SoElement getElement(SoState soState, int n) {
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getElementImpl1(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, n));
    }

    protected void captureThis(SoState soState) {
        SoElement.captureThisImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    protected void setTypeId(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoElement.setTypeIdImpl(this.getNativeResourceHandle(), string);
    }

    protected void capture(SoState soState) {
        SoElement.captureImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    protected SoElement getNextFree() {
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getNextFreeImpl(this.getNativeResourceHandle()));
    }

    protected boolean isPopped() {
        return SoElement.isPoppedImpl(this.getNativeResourceHandle());
    }

    protected boolean matches(SoElement soElement) {
        return SoElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    protected SoElement getNextInStack() {
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getNextInStackImpl(this.getNativeResourceHandle()));
    }

    protected static SoElement getConstElement(SoState soState, Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getConstElementImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, string, n));
    }

    protected SoElement copyMatchInfo() {
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
    }

    protected void setPopped(boolean bl) {
        SoElement.setPoppedImpl(this.getNativeResourceHandle(), bl);
    }

    protected static SoElement getElement(SoState soState, Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getElementImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, string, n));
    }

    protected void init(SoState soState) {
        SoElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    protected SoElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoElement.ctorImpl());
        Class<?> clazz = this.getClass();
        int[] nArray = SoElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz), ElementManager.getSavedClassElementKey(clazz));
        ElementManager.saveClassStackIndex(clazz, nArray[0]);
        ElementManager.saveClassElementKey(clazz, nArray[1]);
    }

    public void push(SoState soState) {
        SoElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void pop(SoState soState, SoElement soElement) {
        SoElement.popImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    static {
        SoElement.nativeDerivedClassInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

