/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.engines;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.engines.SoEngine;
import com.openinventor.inventor.internal.JniInitializer;

public class SoEngineOutput
extends Inventor {
    private static native long getContainerImpl(long var0);

    private static native boolean isEnabledImpl(long var0);

    private static native void enableImpl(long var0, boolean var2);

    private static native int getNumConnectionsImpl(long var0);

    private static native String getConnectionTypeImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoEngineOutput(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getNumConnections() {
        return SoEngineOutput.getNumConnectionsImpl(this.getNativeResourceHandle());
    }

    public SoEngine getContainer() {
        return ObjectManager.getManagedObjectFor(SoEngine.class, SoEngineOutput.getContainerImpl(this.getNativeResourceHandle()));
    }

    public void enable(boolean bl) {
        SoEngineOutput.enableImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isEnabled() {
        return SoEngineOutput.isEnabledImpl(this.getNativeResourceHandle());
    }

    public Class<? extends Inventor> getConnectionClass() {
        return NativeTypeMap.getJavaClass(SoEngineOutput.getConnectionTypeImpl(this.getNativeResourceHandle()));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

