/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.errors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoError;
import com.openinventor.inventor.internal.JniInitializer;

public class SoDebugError
extends SoError {
    private static Handler m_handler = null;
    private static boolean m_nativeCallbackInitialized = false;

    public static void setHandlerCallback(Handler handler) {
        m_handler = handler;
        if (!m_nativeCallbackInitialized) {
            SoDebugError.initNativeCallback();
            m_nativeCallbackInitialized = true;
        }
    }

    private static native void initNativeCallback();

    private static void invoke(long l) {
        if (m_handler != null) {
            SoDebugError soDebugError = ObjectManager.getManagedObjectFor(SoDebugError.class, l);
            m_handler.invoke(soDebugError);
        }
    }

    private static native void postInfoImpl(String var0, String var1);

    private static native void postImpl(String var0, String var1);

    private static native void postWarningImpl(String var0, String var1);

    private static native int getSeverityImpl(long var0);

    private static native long ctorImpl();

    protected SoDebugError(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static void postInfo(String string, String string2) {
        SoDebugError.postInfoImpl(string, string2);
    }

    public static void post(String string, String string2) {
        SoDebugError.postImpl(string, string2);
    }

    public SoDebugError() {
        this(Inventor.ConstructorCommand.CreateInstance, SoDebugError.ctorImpl());
    }

    public static void postWarning(String string, String string2) {
        SoDebugError.postWarningImpl(string, string2);
    }

    public Severities getSeverity() {
        return IntegerValuedEnumHelper.fromIntValue(Severities.class, SoDebugError.getSeverityImpl(this.getNativeResourceHandle()));
    }

    public static interface Handler {
        public void invoke(SoDebugError var1);
    }

    public static enum Severities implements IntegerValuedEnum
    {
        SERROR(Severities.getSERROR()),
        WARNING(Severities.getWARNING()),
        INFO(Severities.getINFO());

        private int value;

        private static native int getINFONative();

        private static int getINFO() {
            JniInitializer.checkInit();
            return Severities.getINFONative();
        }

        private Severities(int n2) {
            this.value = n2;
        }

        private static int getWARNING() {
            JniInitializer.checkInit();
            return Severities.getWARNINGNative();
        }

        private static native int getSERRORNative();

        private static int getSERROR() {
            JniInitializer.checkInit();
            return Severities.getSERRORNative();
        }

        private static native int getWARNINGNative();

        public static Severities valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Severities.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

