/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.errors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoError;
import com.openinventor.inventor.internal.JniInitializer;
import java.util.ArrayList;

public class SoErrorStack
extends SoError {
    private static Handler m_handler = null;
    private static boolean m_nativeCallbackInitialized = false;

    public static void setHandlerCallback(Handler handler) {
        m_handler = handler;
        if (!m_nativeCallbackInitialized) {
            SoErrorStack.initNativeCallback();
            m_nativeCallbackInitialized = true;
        }
    }

    private static native void initNativeCallback();

    private static void invoke(long l) {
        if (m_handler != null) {
            SoErrorStack soErrorStack = ObjectManager.getManagedObjectFor(SoErrorStack.class, l);
            m_handler.invoke(soErrorStack);
        }
    }

    private static native String getStackImpl(long var0);

    private static native void postImpl();

    private static native long[] getStackFramesImpl(long var0);

    protected SoErrorStack(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public ArrayList<StackFrame> getStackFrames() {
        long[] lArray = null;
        lArray = SoErrorStack.getStackFramesImpl(this.getNativeResourceHandle());
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<StackFrame> arrayList = new ArrayList<StackFrame>(lArray.length);
        for (long l : lArray) {
            arrayList.add(ObjectManager.createManagedObject(StackFrame.class, (Long)l, Inventor.ConstructorCommand.CreateInstance));
        }
        return arrayList;
    }

    public static void post() {
        SoErrorStack.postImpl();
    }

    public String getStack() {
        return SoErrorStack.getStackImpl(this.getNativeResourceHandle());
    }

    public static interface Handler {
        public void invoke(SoErrorStack var1);
    }

    public static class StackFrame
    extends Inventor {
        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        protected StackFrame(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public StackFrame(StackFrame stackFrame) {
            this();
            this.setValue(stackFrame);
        }

        public void setValue(StackFrame stackFrame) {
            StackFrame.setValueImpl(this.getNativeResourceHandle(), stackFrame.getNativeResourceHandle());
        }

        public static StackFrame[] toArray(long l, long l2) {
            StackFrame[] stackFrameArray = new StackFrame[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                stackFrameArray[n] = new StackFrame();
                lArray[n] = stackFrameArray[n].getNativeResourceHandle();
                ++n;
            }
            StackFrame.toArrayImpl(l, lArray);
            return stackFrameArray;
        }

        public StackFrame() {
            this(Inventor.ConstructorCommand.CreateInstance, StackFrame.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }
}

