/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class SoMFInt32
extends SoMField {
    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native int getValueAtImpl(long var0, int var2);

    private static native void setValuesImpl(long var0, int var2, int var3, int[] var4);

    private static native int[] getValuesImpl(long var0, int var2);

    private static native void finishEditingImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static native int findImpl(long var0, int var2, boolean var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native long ctorImpl();

    private static native Object startEditingImpl(long var0);

    private static native void set1ValueImpl(long var0, int var2, int var3);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValueImpl(long var0, int var2);

    protected SoMFInt32(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(int n) {
        return this.find(n, false);
    }

    public int getValueAt(int n) {
        return SoMFInt32.getValueAtImpl(this.getNativeResourceHandle(), n);
    }

    public void finishEditing() {
        SoMFInt32.finishEditingImpl(this.getNativeResourceHandle());
    }

    public IntBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFInt32.startEditingImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asIntBuffer();
    }

    public void disableDeleteValues() {
        SoMFInt32.disableDeleteValuesImpl(this.getNativeResourceHandle());
    }

    public SoMFInt32(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFInt32.ctorImpl());
        SoMFInt32.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void setValue(int n) {
        this.onSetValue();
        SoMFInt32.setValueImpl(this.getNativeResourceHandle(), n);
    }

    public void set1Value(int n, int n2) {
        this.onSet1Value(n);
        SoMFInt32.set1ValueImpl(this.getNativeResourceHandle(), n, n2);
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        SoMFInt32.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFInt32) {
            SoMFInt32 soMFInt32 = (SoMFInt32)object;
            return SoMFInt32.equalsImpl(this.getNativeResourceHandle(), soMFInt32.getNativeResourceHandle());
        }
        return false;
    }

    public int[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        return SoMFInt32.getValuesImpl(this.getNativeResourceHandle(), n);
    }

    public IntBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFInt32.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asIntBuffer();
    }

    public void setValues(int n, int[] nArray) {
        int n2 = nArray != null ? nArray.length : 0;
        this.onSetValues(n, n2);
        SoMFInt32.setValuesImpl(this.getNativeResourceHandle(), n, n2, nArray);
    }

    public int find(int n, boolean bl) {
        return SoMFInt32.findImpl(this.getNativeResourceHandle(), n, bl);
    }
}

