/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoMField
extends SoField {
    private ByteBuffer m_userDefinedBuffer = null;

    protected void onSetValue() {
        this.m_userDefinedBuffer = null;
    }

    protected int onSetValuesBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.limit() == 0) {
            throw new IllegalArgumentException("Empty or null user supplied buffer.");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer supplied.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer supplied.");
        }
        if ((long)byteBuffer.limit() % this.getValueSize() != 0L) {
            throw new IllegalArgumentException("Buffer size is incompatible with element size.");
        }
        long l = (long)byteBuffer.limit() / this.getValueSize();
        this.m_userDefinedBuffer = byteBuffer;
        return (int)l;
    }

    @Override
    protected void preMortenClean() {
        this.setNum(0);
        super.preMortenClean();
    }

    private boolean capacityChangeForSetNum(int n) {
        return this.getNum() != n;
    }

    private boolean capacityChangeForDeleteValues(int n, int n2) {
        return n2 != 0;
    }

    private boolean capacityChangeForInsertSpace(int n, int n2) {
        return n2 > 0;
    }

    private boolean capacityChangeForSet1Value(int n) {
        return n >= this.getNum();
    }

    private boolean capacityChangeForSetValues(int n, int n2) {
        return this.getNum() != n + n2;
    }

    protected void onSetNum(int n) {
        if (n >= 0 && n <= 1) {
            this.onSetValue();
        } else if (this.capacityChangeForSetNum(n)) {
            this.capacityChange();
        }
    }

    protected void onDeleteValues(int n, int n2) {
        if (this.capacityChangeForDeleteValues(n, n2)) {
            this.capacityChange();
        }
    }

    protected void onInsertSpace(int n, int n2) {
        if (this.capacityChangeForInsertSpace(n, n2)) {
            this.capacityChange();
        }
    }

    protected void onSet1Value(int n) {
        if (this.capacityChangeForSet1Value(n)) {
            this.capacityChange();
        }
    }

    protected void onSetValues(int n, int n2) {
        if (this.capacityChangeForSetValues(n, n2)) {
            this.capacityChange();
        }
    }

    private void capacityChange() {
        if (this.m_userDefinedBuffer != null) {
            throw new UnsupportedOperationException("Capacity of field cannot be changed while user data is used");
        }
    }

    private static native boolean set1Impl1(long var0, int var2, String var3);

    private static native void insertSpaceImpl(long var0, int var2, int var3);

    private static native void get1Impl(long var0, int var2, String[] var3);

    private static native void setNumImpl(long var0, int var2);

    private static native int getNumImpl(long var0);

    private static native void deleteValuesImpl(long var0, int var2, int var3);

    protected SoMField(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void deleteValues(int n) {
        this.deleteValues(n, -1);
    }

    public void setNum(int n) {
        this.onSetNum(n);
        SoMField.setNumImpl(this.getNativeResourceHandle(), n);
    }

    public int getNum() {
        return SoMField.getNumImpl(this.getNativeResourceHandle());
    }

    public String get1(int n) {
        String[] stringArray = new String[1];
        SoMField.get1Impl(this.getNativeResourceHandle(), n, stringArray);
        return stringArray[0];
    }

    public void deleteValues(int n, int n2) {
        this.onDeleteValues(n, n2);
        SoMField.deleteValuesImpl(this.getNativeResourceHandle(), n, n2);
    }

    public boolean set1(int n, String string) {
        this.onSet1Value(n);
        return SoMField.set1Impl1(this.getNativeResourceHandle(), n, string);
    }

    public void insertSpace(int n, int n2) {
        this.onInsertSpace(n, n2);
        SoMField.insertSpaceImpl(this.getNativeResourceHandle(), n, n2);
    }
}

