/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.helpers;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.helpers.SbGraphicsCapabilities;
import com.openinventor.inventor.internal.JniInitializer;

public class SbGPUCapabilities
extends SbGraphicsCapabilities {
    private static native int getGpuVendorImpl(long var0);

    private static native int getMax3DTextureSizeImpl(long var0);

    private static native int getMaxTextureSizeImpl(long var0);

    private static native void getMaxViewportSizeImpl(long var0, int[] var2);

    private static native String getRendererImpl(long var0);

    private static native int getMaxFixedPipelineTextureUnitsImpl(long var0);

    private static native int getMaxSamplesImpl(long var0);

    private static native int getVersionImpl(long var0);

    private static native int getProfileImpl(long var0);

    private static native int getMaxVertexAttribsImpl(long var0);

    protected SbGPUCapabilities(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getVersion() {
        return SbGPUCapabilities.getVersionImpl(this.getNativeResourceHandle());
    }

    public int getMaxFixedPipelineTextureUnits() {
        return SbGPUCapabilities.getMaxFixedPipelineTextureUnitsImpl(this.getNativeResourceHandle());
    }

    public int getMaxTextureSize() {
        return SbGPUCapabilities.getMaxTextureSizeImpl(this.getNativeResourceHandle());
    }

    public int getMaxSamples() {
        return SbGPUCapabilities.getMaxSamplesImpl(this.getNativeResourceHandle());
    }

    public int getMax3DTextureSize() {
        return SbGPUCapabilities.getMax3DTextureSizeImpl(this.getNativeResourceHandle());
    }

    public String getRenderer() {
        return SbGPUCapabilities.getRendererImpl(this.getNativeResourceHandle());
    }

    public SbVec2i32 getMaxViewportSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        SbGPUCapabilities.getMaxViewportSizeImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        return sbVec2i32;
    }

    public Profiles getProfile() {
        return IntegerValuedEnumHelper.fromIntValue(Profiles.class, SbGPUCapabilities.getProfileImpl(this.getNativeResourceHandle()));
    }

    public int getMaxVertexAttribs() {
        return SbGPUCapabilities.getMaxVertexAttribsImpl(this.getNativeResourceHandle());
    }

    public GpuVendors getGpuVendor() {
        return IntegerValuedEnumHelper.fromIntValue(GpuVendors.class, SbGPUCapabilities.getGpuVendorImpl(this.getNativeResourceHandle()));
    }

    public static enum Profiles implements IntegerValuedEnum
    {
        COMPATIBILITY(Profiles.getCOMPATIBILITY()),
        CORE(Profiles.getCORE());

        private int value;

        private static int getCORE() {
            JniInitializer.checkInit();
            return Profiles.getCORENative();
        }

        private Profiles(int n2) {
            this.value = n2;
        }

        private static native int getCORENative();

        private static native int getCOMPATIBILITYNative();

        private static int getCOMPATIBILITY() {
            JniInitializer.checkInit();
            return Profiles.getCOMPATIBILITYNative();
        }

        public static Profiles valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Profiles.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum GpuVendors implements IntegerValuedEnum
    {
        INTEL_GPU(GpuVendors.getINTELGPU()),
        AMD_GPU(GpuVendors.getAMDGPU()),
        NVIDIA_GPU(GpuVendors.getNVIDIAGPU()),
        UNKNOWN_GPU(GpuVendors.getUNKNOWNGPU());

        private int value;

        private static native int getUNKNOWNGPUNative();

        private static int getNVIDIAGPU() {
            JniInitializer.checkInit();
            return GpuVendors.getNVIDIAGPUNative();
        }

        private GpuVendors(int n2) {
            this.value = n2;
        }

        private static int getUNKNOWNGPU() {
            JniInitializer.checkInit();
            return GpuVendors.getUNKNOWNGPUNative();
        }

        private static native int getNVIDIAGPUNative();

        private static int getINTELGPU() {
            JniInitializer.checkInit();
            return GpuVendors.getINTELGPUNative();
        }

        private static native int getINTELGPUNative();

        private static int getAMDGPU() {
            JniInitializer.checkInit();
            return GpuVendors.getAMDGPUNative();
        }

        private static native int getAMDGPUNative();

        public static GpuVendors valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(GpuVendors.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

