/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.lock;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.lock.SoLicenseProperty;

public class SoLicensedProduct
extends Inventor
implements SafeDisposable {
    private static native int getLicenseCountImpl(long var0);

    private static native String getProductNameImpl(long var0);

    private static native long ctorImpl();

    private static native int getProductImpl(long var0);

    private static native long getLicenseByIndexImpl(long var0, int var2);

    protected SoLicensedProduct(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    public String getProductName() {
        return SoLicensedProduct.getProductNameImpl(this.getNativeResourceHandle());
    }

    public SbProducts getProduct() {
        return IntegerValuedEnumHelper.fromIntValue(SbProducts.class, SoLicensedProduct.getProductImpl(this.getNativeResourceHandle()));
    }

    public int getLicenseCount() {
        return SoLicensedProduct.getLicenseCountImpl(this.getNativeResourceHandle());
    }

    public SoLicenseProperty getLicenseByIndex(int n) {
        return ObjectManager.getManagedObjectFor(SoLicenseProperty.class, SoLicensedProduct.getLicenseByIndexImpl(this.getNativeResourceHandle(), n));
    }

    public SoLicensedProduct() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLicensedProduct.ctorImpl());
    }

    public static enum SbProducts implements IntegerValuedEnum
    {
        OpenInventor(SbProducts.getOpenInventor()),
        HardCopy(SbProducts.getHardCopy()),
        MeshVizXLM(SbProducts.getMeshVizXLM()),
        MeshViz(SbProducts.getMeshViz()),
        MeshVizInterface(SbProducts.getMeshVizInterface()),
        MeshVizExtractor(SbProducts.getMeshVizExtractor()),
        VolumeVizLDM(SbProducts.getVolumeVizLDM()),
        VolumeViz(SbProducts.getVolumeViz()),
        LDMWriter(SbProducts.getLDMWriter()),
        AllInventor(SbProducts.getAllInventor()),
        OivCatia5Reader(SbProducts.getOivCatia5Reader()),
        OivCatia6Reader(SbProducts.getOivCatia6Reader()),
        OivDxfReader(SbProducts.getOivDxfReader()),
        OivDwgReader(SbProducts.getOivDwgReader()),
        OivIgesReader(SbProducts.getOivIgesReader()),
        OivJtReader(SbProducts.getOivJtReader()),
        OivProeReader(SbProducts.getOivProeReader()),
        OivSolidedgeReader(SbProducts.getOivSolidedgeReader()),
        OivSolidworksReader(SbProducts.getOivSolidworksReader()),
        OivStepReader(SbProducts.getOivStepReader()),
        OivUgReader(SbProducts.getOivUgReader()),
        OivVdaReader(SbProducts.getOivVdaReader()),
        OivXmtReader(SbProducts.getOivXmtReader()),
        IvTuneViewer(SbProducts.getIvTuneViewer()),
        RemoteViz(SbProducts.getRemoteViz()),
        ScaleVizCluster(SbProducts.getScaleVizCluster()),
        ScaleVizWorkstation(SbProducts.getScaleVizWorkstation()),
        NumberOfProducts(SbProducts.getNumberOfProducts());

        private int value;

        private static native int getOivStepReaderNative();

        private static int getOivSolidworksReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivSolidworksReaderNative();
        }

        private static native int getOivSolidworksReaderNative();

        private static int getOivStepReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivStepReaderNative();
        }

        private static native int getOivVdaReaderNative();

        private static int getOivUgReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivUgReaderNative();
        }

        private static native int getOivUgReaderNative();

        private static int getOivJtReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivJtReaderNative();
        }

        private static native int getOivJtReaderNative();

        private static int getOivIgesReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivIgesReaderNative();
        }

        private static native int getOivProeReaderNative();

        private static int getOivSolidedgeReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivSolidedgeReaderNative();
        }

        private static native int getOivSolidedgeReaderNative();

        private static int getOivProeReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivProeReaderNative();
        }

        private static native int getScaleVizWorkstationNative();

        private static int getScaleVizCluster() {
            JniInitializer.checkInit();
            return SbProducts.getScaleVizClusterNative();
        }

        private static native int getScaleVizClusterNative();

        private static int getScaleVizWorkstation() {
            JniInitializer.checkInit();
            return SbProducts.getScaleVizWorkstationNative();
        }

        private SbProducts(int n2) {
            this.value = n2;
        }

        private static int getNumberOfProducts() {
            JniInitializer.checkInit();
            return SbProducts.getNumberOfProductsNative();
        }

        private static native int getNumberOfProductsNative();

        private static int getOivXmtReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivXmtReaderNative();
        }

        private static native int getOivXmtReaderNative();

        private static int getOivVdaReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivVdaReaderNative();
        }

        private static native int getIvTuneViewerNative();

        private static int getRemoteViz() {
            JniInitializer.checkInit();
            return SbProducts.getRemoteVizNative();
        }

        private static native int getRemoteVizNative();

        private static int getIvTuneViewer() {
            JniInitializer.checkInit();
            return SbProducts.getIvTuneViewerNative();
        }

        private static native int getOivIgesReaderNative();

        private static int getMeshVizInterface() {
            JniInitializer.checkInit();
            return SbProducts.getMeshVizInterfaceNative();
        }

        private static native int getMeshVizInterfaceNative();

        private static int getMeshViz() {
            JniInitializer.checkInit();
            return SbProducts.getMeshVizNative();
        }

        private static native int getMeshVizExtractorNative();

        private static int getVolumeVizLDM() {
            JniInitializer.checkInit();
            return SbProducts.getVolumeVizLDMNative();
        }

        private static native int getVolumeVizLDMNative();

        private static int getMeshVizExtractor() {
            JniInitializer.checkInit();
            return SbProducts.getMeshVizExtractorNative();
        }

        private static native int getHardCopyNative();

        private static int getOpenInventor() {
            JniInitializer.checkInit();
            return SbProducts.getOpenInventorNative();
        }

        private static native int getOpenInventorNative();

        private static int getHardCopy() {
            JniInitializer.checkInit();
            return SbProducts.getHardCopyNative();
        }

        private static native int getMeshVizNative();

        private static int getMeshVizXLM() {
            JniInitializer.checkInit();
            return SbProducts.getMeshVizXLMNative();
        }

        private static native int getMeshVizXLMNative();

        private static int getOivCatia6Reader() {
            JniInitializer.checkInit();
            return SbProducts.getOivCatia6ReaderNative();
        }

        private static native int getOivCatia6ReaderNative();

        private static int getOivCatia5Reader() {
            JniInitializer.checkInit();
            return SbProducts.getOivCatia5ReaderNative();
        }

        private static native int getOivDxfReaderNative();

        private static int getOivDwgReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivDwgReaderNative();
        }

        private static native int getOivDwgReaderNative();

        private static int getOivDxfReader() {
            JniInitializer.checkInit();
            return SbProducts.getOivDxfReaderNative();
        }

        private static native int getLDMWriterNative();

        private static int getVolumeViz() {
            JniInitializer.checkInit();
            return SbProducts.getVolumeVizNative();
        }

        private static native int getVolumeVizNative();

        private static int getLDMWriter() {
            JniInitializer.checkInit();
            return SbProducts.getLDMWriterNative();
        }

        private static native int getOivCatia5ReaderNative();

        private static int getAllInventor() {
            JniInitializer.checkInit();
            return SbProducts.getAllInventorNative();
        }

        private static native int getAllInventorNative();

        public static SbProducts valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SbProducts.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

