/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;
import java.util.Collection;

public class SbExtrusionGenerator
extends Inventor {
    private static native long createFrom2DPointsImpl(Object[] var0, long var1, long var3, float[] var5);

    private static native long createFrom3DPointsImpl(Object[] var0, long var1, long var3, float[] var5);

    private static native long createFrom2DPointsImpl2(Object[] var0, float[] var1, float var2, float var3);

    private static native long createFrom2DPointsImpl1(Object[] var0, float[] var1, float[] var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbExtrusionGenerator(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SbMatrix sbMatrix) {
        return SbExtrusionGenerator.createFrom2DPoints(collection, sbMatrix, new SbBox3f());
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SoPath soPath, SbViewVolume sbViewVolume) {
        return SbExtrusionGenerator.createFrom2DPoints(collection, soPath, sbViewVolume, new SbBox3f());
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SbMatrix sbMatrix, float f) {
        return SbExtrusionGenerator.createFrom2DPoints(collection, sbMatrix, f, 1.0f);
    }

    public static SoShape createFrom3DPoints(Collection<SbVec3f> collection, SoPath soPath, SbViewVolume sbViewVolume) {
        return SbExtrusionGenerator.createFrom3DPoints(collection, soPath, sbViewVolume, new SbBox3f());
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SbMatrix sbMatrix, float f, float f2) {
        if (collection == null) {
            throw new IllegalArgumentException("pointsInCam cannot be null");
        }
        return ObjectManager.getManagedObjectFor(SoShape.class, SbExtrusionGenerator.createFrom2DPointsImpl2(collection.toArray(), sbMatrix != null ? sbMatrix.array : null, f, f2));
    }

    public static SoShape createFrom3DPoints(Collection<SbVec3f> collection, SoPath soPath, SbViewVolume sbViewVolume, SbBox3f sbBox3f) {
        if (collection == null) {
            throw new IllegalArgumentException("pointsInWorld cannot be null");
        }
        return ObjectManager.getManagedObjectFor(SoShape.class, SbExtrusionGenerator.createFrom3DPointsImpl(collection.toArray(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewVolume != null ? sbViewVolume.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3f != null ? sbBox3f.array : null));
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SoPath soPath, SbViewVolume sbViewVolume, SbBox3f sbBox3f) {
        if (collection == null) {
            throw new IllegalArgumentException("pointsInCam cannot be null");
        }
        return ObjectManager.getManagedObjectFor(SoShape.class, SbExtrusionGenerator.createFrom2DPointsImpl(collection.toArray(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewVolume != null ? sbViewVolume.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3f != null ? sbBox3f.array : null));
    }

    public static SoShape createFrom2DPoints(Collection<SbVec2f> collection, SbMatrix sbMatrix, SbBox3f sbBox3f) {
        if (collection == null) {
            throw new IllegalArgumentException("pointsInCam cannot be null");
        }
        return ObjectManager.getManagedObjectFor(SoShape.class, SbExtrusionGenerator.createFrom2DPointsImpl1(collection.toArray(), sbMatrix != null ? sbMatrix.array : null, sbBox3f != null ? sbBox3f.array : null));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

