/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc.callbacks;

import com.openinventor.internal.GenericAbstractNativeResourceHandle;
import com.openinventor.internal.ProcessReferenceQueueBounded;
import com.openinventor.inventor.errors.SoInternalError;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.Callback;

public class NCallback
extends Callback {
    private CallbackNativeResourceHandle nativeResourceHandle;
    private boolean m_hasDispose;

    protected NCallback(long l) {
        this.nativeResourceHandle = new CallbackNativeResourceHandle(this, l);
        this.nativeResourceHandle.DangerousAddRef();
        this.m_hasDispose = false;
        NCallback.initCustomClass(l, this);
    }

    private static native void initCustomClass(long var0, Object var2);

    public synchronized Long getNativeResourceHandle() {
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.m_hasDispose) {
            throw new SoInternalError("Trying to use a native handle beeing closed.");
        }
        return this.nativeResourceHandle.getHandle();
    }

    public synchronized void dispose() {
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.m_hasDispose || this.nativeResourceHandle.isInvalid()) {
            throw new IllegalStateException("Object already disposed.");
        }
        if (this.nativeResourceHandle.DangerousRefCounter() > 1) {
            throw new IllegalStateException("Object still referenced.");
        }
        if (this.nativeResourceHandle.isEnqueued()) {
            throw new SoInternalError("Object already registered to be disposed.");
        }
        boolean bl = this.nativeResourceHandle.enqueue();
        assert (bl);
        this.m_hasDispose = true;
        ProcessReferenceQueueBounded.run();
    }

    private static final class CallbackNativeResourceHandle
    extends GenericAbstractNativeResourceHandle<NCallback> {
        public CallbackNativeResourceHandle(NCallback nCallback, long l) {
            super(nCallback, l);
        }

        @Override
        public void DangerousRelease() {
            super.DangerousRelease();
            if (this.refCounter == 0) {
                CallbackNativeResourceHandle.deleteNativeHandleImpl(this.getHandle());
            }
        }

        private static native void deleteNativeHandleImpl(long var0);

        static {
            JniInitializer.checkInit();
        }
    }
}

