/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.mpeg;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.helpers.SbGLShareContext;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoMPEGRenderer
extends Inventor {
    private SoGLRenderAction m_ra_setGLRenderAction;

    private static native void setSceneGraphImpl(long var0, long var2);

    private static native void setNumFramesPerSecondImpl(long var0, float var2);

    private static native long getSceneGraphImpl(long var0);

    private static native int getNumFramesPerSecondImpl(long var0);

    private static native void setComponentsImpl(long var0, int var2);

    private static native void addFrameImpl(long var0, byte[] var2);

    private static native int getComponentsImpl(long var0);

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native void setCompressionRateImpl(long var0, float var2);

    private static native long getGLRenderActionImpl(long var0);

    private static native void getBackgroundColorImpl(long var0, float[] var2);

    private static native void setBitPerSecImpl(long var0, float var2);

    private static native void setBackgroundColorImpl(long var0, float[] var2);

    private static native float getCompressionRateImpl(long var0);

    private static native void setShareContextImpl(long var0, long var2);

    private static native void setViewerIsIdleImpl(long var0, boolean var2);

    private static native boolean openFileImpl(long var0, String var2, int var3);

    private static native boolean isRecordingImpl(long var0);

    private static native boolean isViewerIdleImpl(long var0);

    private static native long ctorImpl();

    private static native void setSizeImpl(long var0, short[] var2);

    private static native void getShareContextImpl(long var0, long var2);

    private static native void getSizeImpl(long var0, short[] var2);

    private static native void recordImpl(long var0);

    private static native void stopImpl(long var0);

    private static native void closeFileImpl(long var0);

    private static native void pauseImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoMPEGRenderer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean openFile(String string) {
        return this.openFile(string, 10000);
    }

    public boolean isRecording() {
        return SoMPEGRenderer.isRecordingImpl(this.getNativeResourceHandle());
    }

    public void pause() {
        SoMPEGRenderer.pauseImpl(this.getNativeResourceHandle());
    }

    public void stop() {
        SoMPEGRenderer.stopImpl(this.getNativeResourceHandle());
    }

    public void closeFile() {
        SoMPEGRenderer.closeFileImpl(this.getNativeResourceHandle());
    }

    public float getCompressionRate() {
        return SoMPEGRenderer.getCompressionRateImpl(this.getNativeResourceHandle());
    }

    public SoMPEGRenderer() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMPEGRenderer.ctorImpl());
    }

    public boolean isViewerIdle() {
        return SoMPEGRenderer.isViewerIdleImpl(this.getNativeResourceHandle());
    }

    public void setViewerIsIdle(boolean bl) {
        SoMPEGRenderer.setViewerIsIdleImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean openFile(String string, int n) {
        return SoMPEGRenderer.openFileImpl(this.getNativeResourceHandle(), string, n);
    }

    public void setNumFramesPerSecond(float f) {
        SoMPEGRenderer.setNumFramesPerSecondImpl(this.getNativeResourceHandle(), f);
    }

    public void setBackgroundColor(SbColor sbColor) {
        SoMPEGRenderer.setBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
    }

    public int getNumFramesPerSecond() {
        return SoMPEGRenderer.getNumFramesPerSecondImpl(this.getNativeResourceHandle());
    }

    public SoNode getSceneGraph() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoMPEGRenderer.getSceneGraphImpl(this.getNativeResourceHandle()));
    }

    public void setBitPerSec(float f) {
        SoMPEGRenderer.setBitPerSecImpl(this.getNativeResourceHandle(), f);
    }

    public SoGLRenderAction getGLRenderAction() {
        return ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoMPEGRenderer.getGLRenderActionImpl(this.getNativeResourceHandle()));
    }

    public void setCompressionRate(float f) {
        SoMPEGRenderer.setCompressionRateImpl(this.getNativeResourceHandle(), f);
    }

    public SbColor getBackgroundColor() {
        SbColor sbColor = new SbColor();
        SoMPEGRenderer.getBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        return sbColor;
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_ra_setGLRenderAction = soGLRenderAction;
        SoMPEGRenderer.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbVec2s getSize() {
        SbVec2s sbVec2s = new SbVec2s();
        SoMPEGRenderer.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public SbGLShareContext getShareContext() {
        SbGLShareContext sbGLShareContext = new SbGLShareContext();
        SoMPEGRenderer.getShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext.getNativeResourceHandle());
        return sbGLShareContext;
    }

    public void setSize(SbVec2s sbVec2s) {
        SoMPEGRenderer.setSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
    }

    public void record() {
        SoMPEGRenderer.recordImpl(this.getNativeResourceHandle());
    }

    public void setComponents(Components components) {
        SoMPEGRenderer.setComponentsImpl(this.getNativeResourceHandle(), components.getValue());
    }

    public void addFrame(byte[] byArray) {
        SoMPEGRenderer.addFrameImpl(this.getNativeResourceHandle(), byArray);
    }

    public void setSceneGraph(SoNode soNode) {
        SoMPEGRenderer.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setShareContext(SbGLShareContext sbGLShareContext) {
        SoMPEGRenderer.setShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext != null ? sbGLShareContext.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public Components getComponents() {
        return IntegerValuedEnumHelper.fromIntValue(Components.class, SoMPEGRenderer.getComponentsImpl(this.getNativeResourceHandle()));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum Components implements IntegerValuedEnum
    {
        LUMINANCE(Components.getLUMINANCE()),
        LUMINANCE_TRANSPARENCY(Components.getLUMINANCETRANSPARENCY()),
        RGB(Components.getRGB()),
        RGB_TRANSPARENCY(Components.getRGBTRANSPARENCY());

        private int value;

        private static native int getRGBTRANSPARENCYNative();

        private static int getRGB() {
            JniInitializer.checkInit();
            return Components.getRGBNative();
        }

        private Components(int n2) {
            this.value = n2;
        }

        private static int getRGBTRANSPARENCY() {
            JniInitializer.checkInit();
            return Components.getRGBTRANSPARENCYNative();
        }

        private static native int getRGBNative();

        private static int getLUMINANCE() {
            JniInitializer.checkInit();
            return Components.getLUMINANCENative();
        }

        private static native int getLUMINANCENative();

        private static int getLUMINANCETRANSPARENCY() {
            JniInitializer.checkInit();
            return Components.getLUMINANCETRANSPARENCYNative();
        }

        private static native int getLUMINANCETRANSPARENCYNative();

        public static Components valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Components.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

