/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFVec2f;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoBaseExtrusion;

public class SoCircularExtrusion
extends SoBaseExtrusion {
    public final SoSFFloat radius;
    public final SoSFVec2f activeSection;
    public final SoSFEnum<SpineSimplificationModes> spineSimplificationMode;

    private static native long ctorImpl();

    protected SoCircularExtrusion(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.radius = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCircularExtrusion.getFieldHandle(this.getNativeResourceHandle(), "radius"));
        this.activeSection = ObjectManager.getManagedObjectFor(SoSFVec2f.class, SoCircularExtrusion.getFieldHandle(this.getNativeResourceHandle(), "activeSection"));
        this.spineSimplificationMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoCircularExtrusion.getFieldHandle(this.getNativeResourceHandle(), "spineSimplificationMode"), SpineSimplificationModes.class);
    }

    static native String getClassTypeId();

    public SoCircularExtrusion() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCircularExtrusion.ctorImpl());
    }

    public static enum SpineSimplificationModes implements IntegerValuedEnum
    {
        DEFAULT(SpineSimplificationModes.getDEFAULT()),
        RESPECT_MATERIALS(SpineSimplificationModes.getRESPECTMATERIALS());

        private int value;

        private static int getRESPECTMATERIALS() {
            JniInitializer.checkInit();
            return SpineSimplificationModes.getRESPECTMATERIALSNative();
        }

        private SpineSimplificationModes(int n2) {
            this.value = n2;
        }

        private static native int getRESPECTMATERIALSNative();

        private static native int getDEFAULTNative();

        private static int getDEFAULT() {
            JniInitializer.checkInit();
            return SpineSimplificationModes.getDEFAULTNative();
        }

        public static SpineSimplificationModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SpineSimplificationModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

