/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFFloat;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoColorMap
extends SoNode {
    public final SoSFFloat min;
    public final SoSFFloat max;
    public final SoSFEnum<PredefinedColorMaps> predefinedColorMap;
    public final SoSFEnum<ColorMapFormats> colorMapFormat;
    public final SoMFFloat colorMap;
    public final SoSFEnum<Interpolations> interpolation;

    private static native long ctorImpl();

    private static native int getNumColorImpl(long var0);

    private static native boolean hasTransparencyImpl(long var0);

    protected SoColorMap(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.min = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "min"));
        this.max = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "max"));
        this.predefinedColorMap = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "predefinedColorMap"), PredefinedColorMaps.class);
        this.colorMapFormat = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "colorMapFormat"), ColorMapFormats.class);
        this.colorMap = ObjectManager.getManagedObjectFor(SoMFFloat.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "colorMap"));
        this.interpolation = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoColorMap.getFieldHandle(this.getNativeResourceHandle(), "interpolation"), Interpolations.class);
    }

    static native String getClassTypeId();

    public int getNumColor() {
        return SoColorMap.getNumColorImpl(this.getNativeResourceHandle());
    }

    public SoColorMap() {
        this(Inventor.ConstructorCommand.CreateInstance, SoColorMap.ctorImpl());
    }

    public boolean hasTransparency() {
        return SoColorMap.hasTransparencyImpl(this.getNativeResourceHandle());
    }

    public static enum PredefinedColorMaps implements IntegerValuedEnum
    {
        NONE(PredefinedColorMaps.getNONE()),
        GRAY(PredefinedColorMaps.getGRAY()),
        TEMPERATURE(PredefinedColorMaps.getTEMPERATURE()),
        PHYSICS(PredefinedColorMaps.getPHYSICS()),
        STANDARD(PredefinedColorMaps.getSTANDARD()),
        GLOW(PredefinedColorMaps.getGLOW()),
        BLUE_RED(PredefinedColorMaps.getBLUERED()),
        SEISMIC(PredefinedColorMaps.getSEISMIC()),
        BLUE_WHITE_RED(PredefinedColorMaps.getBLUEWHITERED()),
        INTENSITY(PredefinedColorMaps.getINTENSITY()),
        LABEL_256(PredefinedColorMaps.getLABEL256()),
        VOLREN_RED(PredefinedColorMaps.getVOLRENRED()),
        VOLREN_GREEN(PredefinedColorMaps.getVOLRENGREEN()),
        AIRWAY(PredefinedColorMaps.getAIRWAY()),
        AIRWAY_SURFACES(PredefinedColorMaps.getAIRWAYSURFACES()),
        INTENSITY_REVERSED(PredefinedColorMaps.getINTENSITYREVERSED());

        private int value;

        private static native int getVOLRENREDNative();

        private static int getLABEL256() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getLABEL256Native();
        }

        private static native int getVOLRENGREENNative();

        private static int getVOLRENRED() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getVOLRENREDNative();
        }

        private static native int getINTENSITYNative();

        private static int getBLUEWHITERED() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getBLUEWHITEREDNative();
        }

        private static native int getLABEL256Native();

        private static int getINTENSITY() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getINTENSITYNative();
        }

        private static native int getINTENSITYREVERSEDNative();

        private static int getAIRWAYSURFACES() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getAIRWAYSURFACESNative();
        }

        private PredefinedColorMaps(int n2) {
            this.value = n2;
        }

        private static int getINTENSITYREVERSED() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getINTENSITYREVERSEDNative();
        }

        private static native int getAIRWAYNative();

        private static int getVOLRENGREEN() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getVOLRENGREENNative();
        }

        private static native int getAIRWAYSURFACESNative();

        private static int getAIRWAY() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getAIRWAYNative();
        }

        private static native int getBLUEWHITEREDNative();

        private static int getTEMPERATURE() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getTEMPERATURENative();
        }

        private static native int getTEMPERATURENative();

        private static int getPHYSICS() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getPHYSICSNative();
        }

        private static native int getPHYSICSNative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getNONENative();
        }

        private static native int getNONENative();

        private static int getGRAY() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getGRAYNative();
        }

        private static native int getGRAYNative();

        private static int getBLUERED() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getBLUEREDNative();
        }

        private static native int getBLUEREDNative();

        private static int getSEISMIC() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getSEISMICNative();
        }

        private static native int getSEISMICNative();

        private static int getSTANDARD() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getSTANDARDNative();
        }

        private static native int getSTANDARDNative();

        private static int getGLOW() {
            JniInitializer.checkInit();
            return PredefinedColorMaps.getGLOWNative();
        }

        private static native int getGLOWNative();

        public static PredefinedColorMaps valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PredefinedColorMaps.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum ColorMapFormats implements IntegerValuedEnum
    {
        LUMINANCE(ColorMapFormats.getLUMINANCE()),
        ALPHA(ColorMapFormats.getALPHA()),
        LUMINANCE_ALPHA(ColorMapFormats.getLUMINANCEALPHA()),
        RGB(ColorMapFormats.getRGB()),
        RGB_ALPHA(ColorMapFormats.getRGBALPHA());

        private int value;

        private static int getRGB() {
            JniInitializer.checkInit();
            return ColorMapFormats.getRGBNative();
        }

        private static native int getRGBNative();

        private static native int getRGBALPHANative();

        private ColorMapFormats(int n2) {
            this.value = n2;
        }

        private static int getRGBALPHA() {
            JniInitializer.checkInit();
            return ColorMapFormats.getRGBALPHANative();
        }

        private static int getLUMINANCEALPHA() {
            JniInitializer.checkInit();
            return ColorMapFormats.getLUMINANCEALPHANative();
        }

        private static int getLUMINANCE() {
            JniInitializer.checkInit();
            return ColorMapFormats.getLUMINANCENative();
        }

        private static native int getLUMINANCENative();

        private static native int getALPHANative();

        private static native int getLUMINANCEALPHANative();

        private static int getALPHA() {
            JniInitializer.checkInit();
            return ColorMapFormats.getALPHANative();
        }

        public static ColorMapFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ColorMapFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum Interpolations implements IntegerValuedEnum
    {
        NEAREST(Interpolations.getNEAREST()),
        LINEAR(Interpolations.getLINEAR());

        private int value;

        private static int getLINEAR() {
            JniInitializer.checkInit();
            return Interpolations.getLINEARNative();
        }

        private Interpolations(int n2) {
            this.value = n2;
        }

        private static native int getLINEARNative();

        private static native int getNEARESTNative();

        private static int getNEAREST() {
            JniInitializer.checkInit();
            return Interpolations.getNEARESTNative();
        }

        public static Interpolations valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Interpolations.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

