/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;

public class SoCylinder
extends SoShape {
    public final SoSFBitMask<PartType> parts;
    public final SoSFFloat radius;
    public final SoSFFloat height;

    private static native long ctorImpl();

    private static native void addPartImpl(long var0, int var2);

    private static native void removePartImpl(long var0, int var2);

    private static native boolean hasPartImpl(long var0, int var2);

    protected SoCylinder(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.parts = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "parts"), PartType.class);
        this.radius = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "radius"));
        this.height = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "height"));
    }

    static native String getClassTypeId();

    public void addPart(PartType partType) {
        SoCylinder.addPartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public void removePart(PartType partType) {
        SoCylinder.removePartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public boolean hasPart(PartType partType) {
        return SoCylinder.hasPartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public SoCylinder() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCylinder.ctorImpl());
    }

    public static enum PartType implements IntegerValuedEnum
    {
        SIDES(PartType.getSIDES()),
        TOP(PartType.getTOP()),
        BOTTOM(PartType.getBOTTOM()),
        ALL(PartType.getALL());

        private int value;

        private static native int getALLNative();

        private static int getBOTTOM() {
            JniInitializer.checkInit();
            return PartType.getBOTTOMNative();
        }

        private PartType(int n2) {
            this.value = n2;
        }

        private static int getALL() {
            JniInitializer.checkInit();
            return PartType.getALLNative();
        }

        private static native int getBOTTOMNative();

        private static int getSIDES() {
            JniInitializer.checkInit();
            return PartType.getSIDESNative();
        }

        private static native int getSIDESNative();

        private static int getTOP() {
            JniInitializer.checkInit();
            return PartType.getTOPNative();
        }

        private static native int getTOPNative();

        public static PartType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PartType.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

