/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.SoNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SoEventCallback
extends SoNode {
    protected Map<String, HashSet<SoEventCallbackCB>> m_eventCBMap = new HashMap<String, HashSet<SoEventCallbackCB>>();

    public void addEventCallback(Class<?> clazz, SoEventCallbackCB soEventCallbackCB) {
        this.addEventCallback(clazz.getName(), soEventCallbackCB, null);
    }

    public void addEventCallback(Class<?> clazz, SoEventCallbackCB soEventCallbackCB, Object object) {
        this.addEventCallback(clazz.getName(), soEventCallbackCB, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventCallback(String string, SoEventCallbackCB soEventCallbackCB, Object object) {
        if (string != null && soEventCallbackCB != null) {
            Map<String, HashSet<SoEventCallbackCB>> map = this.m_eventCBMap;
            synchronized (map) {
                HashSet<SoEventCallbackCB> hashSet = this.m_eventCBMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    this.m_eventCBMap.put(string, hashSet);
                }
                hashSet.add(soEventCallbackCB);
                SoEventCallback.addEventCallbackImpl(this.getNativeResourceHandle(), string, soEventCallbackCB, object, soEventCallbackCB.getNativeResourceHandle());
            }
        }
    }

    private static native void addEventCallbackImpl(long var0, String var2, SoEventCallbackCB var3, Object var4, long var5);

    public void removeEventCallback(Class<?> clazz, SoEventCallbackCB soEventCallbackCB, Object object) {
        this.removeEventCallback(clazz.getName(), soEventCallbackCB, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventCallback(String string, SoEventCallbackCB soEventCallbackCB, Object object) {
        if (string != null && soEventCallbackCB != null) {
            Map<String, HashSet<SoEventCallbackCB>> map = this.m_eventCBMap;
            synchronized (map) {
                HashSet<SoEventCallbackCB> hashSet = this.m_eventCBMap.get(string);
                if (hashSet != null) {
                    hashSet.remove(soEventCallbackCB);
                }
                SoEventCallback.removeEventCallbackImpl(this.getNativeResourceHandle(), string, soEventCallbackCB.getNativeResourceHandle());
            }
        }
    }

    private static native void removeEventCallbackImpl(long var0, String var2, long var3);

    private static native void setHandledImpl(long var0);

    private static native void setPathImpl(long var0, long var2);

    private static native boolean isHandledImpl(long var0);

    private static native long getEventImpl(long var0);

    private static native long getActionImpl(long var0);

    private static native long getPathImpl(long var0);

    private static native long ctorImpl();

    private static native long getPickedPointImpl(long var0);

    private static native void releaseEventsImpl(long var0);

    private static native void grabEventsImpl(long var0);

    protected SoEventCallback(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoEvent getEvent() {
        return ObjectManager.getManagedObjectFor(SoEvent.class, SoEventCallback.getEventImpl(this.getNativeResourceHandle()));
    }

    public void setHandled() {
        SoEventCallback.setHandledImpl(this.getNativeResourceHandle());
    }

    public SoPath getPath() {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoEventCallback.getPathImpl(this.getNativeResourceHandle()));
    }

    public SoPickedPoint getPickedPoint() {
        return ObjectManager.getManagedObjectFor(SoPickedPoint.class, SoEventCallback.getPickedPointImpl(this.getNativeResourceHandle()));
    }

    public SoHandleEventAction getAction() {
        return ObjectManager.getManagedObjectFor(SoHandleEventAction.class, SoEventCallback.getActionImpl(this.getNativeResourceHandle()));
    }

    public boolean isHandled() {
        return SoEventCallback.isHandledImpl(this.getNativeResourceHandle());
    }

    public SoEventCallback() {
        this(Inventor.ConstructorCommand.CreateInstance, SoEventCallback.ctorImpl());
    }

    public void releaseEvents() {
        SoEventCallback.releaseEventsImpl(this.getNativeResourceHandle());
    }

    public void setPath(SoPath soPath) {
        SoEventCallback.setPathImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void grabEvents() {
        SoEventCallback.grabEventsImpl(this.getNativeResourceHandle());
    }
}

