/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFUShort;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.nodes.SoSeparator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;

public class SoExtSelection
extends SoSelection {
    public final SoSFEnum<LassoTypes> lassoType;
    public final SoSFEnum<LassoPolicies> lassoPolicy;
    public final SoSFEnum<LassoModes> lassoMode;
    public final SoSFBool animateLasso;
    public final SoSFColor lassoColor;
    public final SoSFFloat lassoWidth;
    public final SoSFUShort lassoPattern;
    public final SoSFInt32 lassoPatternScaleFactor;
    public final SbEventHandler<PreFilterEventArg> onPreFilter;

    private static native boolean isOverlayLassoAnimatedImpl(long var0);

    private static native int getOverlayLassoColorIndexImpl(long var0);

    private static native long getOverlaySceneGraphImpl(long var0);

    private static native long[] getSelectionPathListImpl(long var0);

    private static native void setOverlayLassoColorIndexImpl(long var0, int var2);

    private static native void setLassoColorImpl(long var0, float[] var2);

    private static native void setLassoWidthImpl(long var0, float var2);

    private static native void setOverlayLassoPatternImpl(long var0, short var2);

    private static native float getLassoWidthImpl(long var0);

    private static native void animateOverlayLassoImpl(long var0, boolean var2);

    private static native void getLassoColorImpl(long var0, float[] var2);

    private static native short getOverlayLassoPatternImpl(long var0);

    private static native void selectImpl(long var0, long var2, int var4, Object[] var5, long var6, boolean var8);

    private static native long getSelectionSceneGraphImpl(long var0);

    private static native long getLassoCoordsDCImpl(long var0, int[] var2);

    private static native Object getDirectLassoCoordsDCImpl(long var0, int[] var2);

    private static native long addOnPreFilterEventHandler(long var0, OnPreFilterEventHandler var2, String var3);

    private static native boolean removeOnPreFilterEventHandler(long var0, long var2);

    private static native boolean isUsingFastEditingImpl(long var0);

    private static native void useFastEditingImpl(long var0, boolean var2);

    private static native long getLassoCoordsWCImpl(long var0, int[] var2);

    private static native void setSelectionSceneGraphImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native Object getDirectLassoCoordsWCImpl(long var0, int[] var2);

    protected SoExtSelection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.lassoType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoType"), LassoTypes.class);
        this.lassoPolicy = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoPolicy"), LassoPolicies.class);
        this.lassoMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoMode"), LassoModes.class);
        this.animateLasso = ObjectManager.getManagedObjectFor(SoSFBool.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "animateLasso"));
        this.lassoColor = ObjectManager.getManagedObjectFor(SoSFColor.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoColor"));
        this.lassoWidth = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoWidth"));
        this.lassoPattern = ObjectManager.getManagedObjectFor(SoSFUShort.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoPattern"));
        this.lassoPatternScaleFactor = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoPatternScaleFactor"));
        this.onPreFilter = new OnPreFilterEventHandler();
    }

    static native String getClassTypeId();

    public void useFastEditing() {
        this.useFastEditing(true);
    }

    @Deprecated(since="10.0.0.0")
    public void animateOverlayLasso() {
        this.animateOverlayLasso(true);
    }

    @Deprecated(since="10.0.0.0")
    public void setOverlayLassoColorIndex(int n) {
        SoExtSelection.setOverlayLassoColorIndexImpl(this.getNativeResourceHandle(), n);
    }

    @Deprecated(since="10.0.0.0")
    public int getOverlayLassoColorIndex() {
        return SoExtSelection.getOverlayLassoColorIndexImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="10.0.0.0")
    public SbColor getLassoColor() {
        SbColor sbColor = new SbColor();
        SoExtSelection.getLassoColorImpl(this.getNativeResourceHandle(), sbColor.array);
        return sbColor;
    }

    @Deprecated(since="10.0.0.0")
    public void setLassoColor(SbColor sbColor) {
        SoExtSelection.setLassoColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
    }

    public SoSeparator getOverlaySceneGraph() {
        return ObjectManager.getManagedObjectFor(SoSeparator.class, SoExtSelection.getOverlaySceneGraphImpl(this.getNativeResourceHandle()));
    }

    public SoExtSelection() {
        this(Inventor.ConstructorCommand.CreateInstance, SoExtSelection.ctorImpl());
    }

    public void select(SoNode soNode, SbVec2f[] sbVec2fArray, SbViewportRegion sbViewportRegion, boolean bl) {
        SoExtSelection.selectImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec2fArray.length, sbVec2fArray, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
    }

    public boolean isUsingFastEditing() {
        return SoExtSelection.isUsingFastEditingImpl(this.getNativeResourceHandle());
    }

    public void useFastEditing(boolean bl) {
        SoExtSelection.useFastEditingImpl(this.getNativeResourceHandle(), bl);
    }

    public FloatBuffer getDirectLassoCoordsWC() {
        int[] nArray = new int[1];
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoExtSelection.getDirectLassoCoordsWCImpl(this.getNativeResourceHandle(), nArray);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public void setSelectionSceneGraph(SoNode soNode) {
        SoExtSelection.setSelectionSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbVec3f[] getLassoCoordsWC() {
        int[] nArray = new int[1];
        long l = Inventor.ZeroHandle;
        l = SoExtSelection.getLassoCoordsWCImpl(this.getNativeResourceHandle(), nArray);
        return SbVec3f.toArray(l, nArray[0]);
    }

    public ShortBuffer getDirectLassoCoordsDC() {
        int[] nArray = new int[1];
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoExtSelection.getDirectLassoCoordsDCImpl(this.getNativeResourceHandle(), nArray);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asShortBuffer();
    }

    public SbVec2s[] getLassoCoordsDC() {
        int[] nArray = new int[1];
        long l = Inventor.ZeroHandle;
        l = SoExtSelection.getLassoCoordsDCImpl(this.getNativeResourceHandle(), nArray);
        return SbVec2s.toArray(l, nArray[0]);
    }

    public SoNode getSelectionSceneGraph() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoExtSelection.getSelectionSceneGraphImpl(this.getNativeResourceHandle()));
    }

    public Vector<SoPath> getSelectionPathList() {
        Vector<SoPath> vector = null;
        vector = SoExtSelection.toVector(SoPath.class, SoExtSelection.getSelectionPathListImpl(this.getNativeResourceHandle()));
        return vector;
    }

    @Deprecated(since="10.0.0.0")
    public void setOverlayLassoPattern(short s) {
        SoExtSelection.setOverlayLassoPatternImpl(this.getNativeResourceHandle(), s);
    }

    @Deprecated(since="10.0.0.0")
    public float getLassoWidth() {
        return SoExtSelection.getLassoWidthImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="10.0.0.0")
    public void setLassoWidth(float f) {
        SoExtSelection.setLassoWidthImpl(this.getNativeResourceHandle(), f);
    }

    @Deprecated(since="10.0.0.0")
    public boolean isOverlayLassoAnimated() {
        return SoExtSelection.isOverlayLassoAnimatedImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="10.0.0.0")
    public void animateOverlayLasso(boolean bl) {
        SoExtSelection.animateOverlayLassoImpl(this.getNativeResourceHandle(), bl);
    }

    @Deprecated(since="10.0.0.0")
    public short getOverlayLassoPattern() {
        return SoExtSelection.getOverlayLassoPatternImpl(this.getNativeResourceHandle());
    }

    public static enum LassoTypes implements IntegerValuedEnum
    {
        NOLASSO(LassoTypes.getNOLASSO()),
        LASSO(LassoTypes.getLASSO()),
        RECTANGLE(LassoTypes.getRECTANGLE()),
        ELLIPSE(LassoTypes.getELLIPSE());

        private int value;

        private static native int getELLIPSENative();

        private static int getRECTANGLE() {
            JniInitializer.checkInit();
            return LassoTypes.getRECTANGLENative();
        }

        private LassoTypes(int n2) {
            this.value = n2;
        }

        private static int getELLIPSE() {
            JniInitializer.checkInit();
            return LassoTypes.getELLIPSENative();
        }

        private static native int getRECTANGLENative();

        private static int getNOLASSO() {
            JniInitializer.checkInit();
            return LassoTypes.getNOLASSONative();
        }

        private static native int getNOLASSONative();

        private static int getLASSO() {
            JniInitializer.checkInit();
            return LassoTypes.getLASSONative();
        }

        private static native int getLASSONative();

        public static LassoTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum LassoPolicies implements IntegerValuedEnum
    {
        FULL_BBOX(LassoPolicies.getFULLBBOX()),
        PART_BBOX(LassoPolicies.getPARTBBOX()),
        FULL(LassoPolicies.getFULL()),
        PART(LassoPolicies.getPART());

        private int value;

        private static native int getPARTNative();

        private static int getFULL() {
            JniInitializer.checkInit();
            return LassoPolicies.getFULLNative();
        }

        private LassoPolicies(int n2) {
            this.value = n2;
        }

        private static int getPART() {
            JniInitializer.checkInit();
            return LassoPolicies.getPARTNative();
        }

        private static native int getFULLNative();

        private static int getFULLBBOX() {
            JniInitializer.checkInit();
            return LassoPolicies.getFULLBBOXNative();
        }

        private static native int getFULLBBOXNative();

        private static int getPARTBBOX() {
            JniInitializer.checkInit();
            return LassoPolicies.getPARTBBOXNative();
        }

        private static native int getPARTBBOXNative();

        public static LassoPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum LassoModes implements IntegerValuedEnum
    {
        VISIBLE_SHAPES(LassoModes.getVISIBLESHAPES()),
        ALL_SHAPES(LassoModes.getALLSHAPES());

        private int value;

        private static int getALLSHAPES() {
            JniInitializer.checkInit();
            return LassoModes.getALLSHAPESNative();
        }

        private LassoModes(int n2) {
            this.value = n2;
        }

        private static native int getALLSHAPESNative();

        private static native int getVISIBLESHAPESNative();

        private static int getVISIBLESHAPES() {
            JniInitializer.checkInit();
            return LassoModes.getVISIBLESHAPESNative();
        }

        public static LassoModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private class OnPreFilterEventHandler
    extends SbEventHandler<PreFilterEventArg> {
        private OnPreFilterEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoExtSelection.removeOnPreFilterEventHandler(SoExtSelection.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = PreFilterEventArg.class.getName();
            this.m_nativeEventHandler = SoExtSelection.addOnPreFilterEventHandler(SoExtSelection.this.getNativeResourceHandle(), this, string);
        }
    }

    public static class PreFilterEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native void skipNodeImpl(long var0);

        private static native long getNodeImpl(long var0);

        private static native long getPathImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        private static native boolean isNodeSkippedImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected PreFilterEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public SoPath getPath() {
            return ObjectManager.getManagedObjectFor(SoPath.class, PreFilterEventArg.getPathImpl(this.getNativeResourceHandle()));
        }

        public PreFilterEventArg(SoPath soPath, SoExtSelection soExtSelection) {
            this(Inventor.ConstructorCommand.CreateInstance, PreFilterEventArg.ctorImpl(soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, soExtSelection != null ? soExtSelection.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public void setValue(PreFilterEventArg preFilterEventArg) {
            PreFilterEventArg.setValueImpl(this.getNativeResourceHandle(), preFilterEventArg.getNativeResourceHandle());
        }

        public void skipNode() {
            PreFilterEventArg.skipNodeImpl(this.getNativeResourceHandle());
        }

        public SoNode getNode() {
            return ObjectManager.getManagedObjectFor(SoNode.class, PreFilterEventArg.getNodeImpl(this.getNativeResourceHandle()));
        }

        public boolean isNodeSkipped() {
            return PreFilterEventArg.isNodeSkippedImpl(this.getNativeResourceHandle());
        }

        @Override
        public SoExtSelection getSource() {
            return ObjectManager.getManagedObjectFor(SoExtSelection.class, PreFilterEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static enum ReturnTypes implements IntegerValuedEnum
    {
        NOSELECT_CONTINUE(ReturnTypes.getNOSELECTCONTINUE()),
        SELECT_RETURN(ReturnTypes.getSELECTRETURN()),
        SELECT_CONTINUE(ReturnTypes.getSELECTCONTINUE()),
        NOSELECT_RETURN(ReturnTypes.getNOSELECTRETURN());

        private int value;

        private static native int getNOSELECTRETURNNative();

        private static int getSELECTCONTINUE() {
            JniInitializer.checkInit();
            return ReturnTypes.getSELECTCONTINUENative();
        }

        private ReturnTypes(int n2) {
            this.value = n2;
        }

        private static int getNOSELECTRETURN() {
            JniInitializer.checkInit();
            return ReturnTypes.getNOSELECTRETURNNative();
        }

        private static native int getSELECTCONTINUENative();

        private static int getNOSELECTCONTINUE() {
            JniInitializer.checkInit();
            return ReturnTypes.getNOSELECTCONTINUENative();
        }

        private static native int getNOSELECTCONTINUENative();

        private static int getSELECTRETURN() {
            JniInitializer.checkInit();
            return ReturnTypes.getSELECTRETURNNative();
        }

        private static native int getSELECTRETURNNative();

        public static ReturnTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ReturnTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

