/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoFont
extends SoNode {
    public final SoSFString name;
    public final SoSFFloat size;
    public final SoSFEnum<RenderStyles> renderStyle;

    private static native void setNumFontCachesImpl(int var0);

    private static native boolean isJapaneseSFEnabledImpl();

    private static native int getCurrNumFontCachesImpl();

    private static native void setFontPathsImpl(String var0);

    private static native int getNumFontCachesImpl();

    private static native boolean isAvailableFontImpl(String var0);

    private static native void clearFontNameCacheImpl();

    private static native long ctorImpl();

    private static native String getFontPathsImpl();

    private static native void addFontPathsImpl(String var0);

    private static native void enableJapaneseSFImpl(boolean var0);

    protected SoFont(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.name = ObjectManager.getManagedObjectFor(SoSFString.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "name"));
        this.size = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "size"));
        this.renderStyle = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "renderStyle"), RenderStyles.class);
    }

    static native String getClassTypeId();

    public static void enableJapaneseSF() {
        SoFont.enableJapaneseSF(true);
    }

    public static void setNumFontCaches(int n) {
        SoFont.setNumFontCachesImpl(n);
    }

    public static boolean isJapaneseSFEnabled() {
        return SoFont.isJapaneseSFEnabledImpl();
    }

    public static boolean isAvailableFont(String string) {
        return SoFont.isAvailableFontImpl(string);
    }

    public static void enableJapaneseSF(boolean bl) {
        SoFont.enableJapaneseSFImpl(bl);
    }

    public static int getNumFontCaches() {
        return SoFont.getNumFontCachesImpl();
    }

    public static void addFontPaths(String string) {
        SoFont.addFontPathsImpl(string);
    }

    public static String getFontPaths() {
        return SoFont.getFontPathsImpl();
    }

    public static void clearFontNameCache() {
        SoFont.clearFontNameCacheImpl();
    }

    public static int getCurrNumFontCaches() {
        return SoFont.getCurrNumFontCachesImpl();
    }

    public SoFont() {
        this(Inventor.ConstructorCommand.CreateInstance, SoFont.ctorImpl());
    }

    public static void setFontPaths(String string) {
        SoFont.setFontPathsImpl(string);
    }

    public static enum RenderStyles implements IntegerValuedEnum
    {
        POLYGON(RenderStyles.getPOLYGON()),
        TEXTURE(RenderStyles.getTEXTURE()),
        TEXTURE_DELAYED(RenderStyles.getTEXTUREDELAYED()),
        POLYGON_AND_OUTLINE(RenderStyles.getPOLYGONANDOUTLINE());

        private int value;

        private static native int getPOLYGONANDOUTLINENative();

        private static int getTEXTUREDELAYED() {
            JniInitializer.checkInit();
            return RenderStyles.getTEXTUREDELAYEDNative();
        }

        private RenderStyles(int n2) {
            this.value = n2;
        }

        private static int getPOLYGONANDOUTLINE() {
            JniInitializer.checkInit();
            return RenderStyles.getPOLYGONANDOUTLINENative();
        }

        private static native int getTEXTUREDELAYEDNative();

        private static int getPOLYGON() {
            JniInitializer.checkInit();
            return RenderStyles.getPOLYGONNative();
        }

        private static native int getPOLYGONNative();

        private static int getTEXTURE() {
            JniInitializer.checkInit();
            return RenderStyles.getTEXTURENative();
        }

        private static native int getTEXTURENative();

        public static RenderStyles valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderStyles.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

