/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFString;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoInteractiveComplexity
extends SoNode {
    public final SoMFString fieldSettings;
    public final SoSFFloat refinementDelay;
    public final SoSFEnum<InteractiveModes> interactiveMode;

    private static native long ctorImpl();

    protected SoInteractiveComplexity(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.fieldSettings = ObjectManager.getManagedObjectFor(SoMFString.class, SoInteractiveComplexity.getFieldHandle(this.getNativeResourceHandle(), "fieldSettings"));
        this.refinementDelay = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoInteractiveComplexity.getFieldHandle(this.getNativeResourceHandle(), "refinementDelay"));
        this.interactiveMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoInteractiveComplexity.getFieldHandle(this.getNativeResourceHandle(), "interactiveMode"), InteractiveModes.class);
    }

    static native String getClassTypeId();

    public SoInteractiveComplexity() {
        this(Inventor.ConstructorCommand.CreateInstance, SoInteractiveComplexity.ctorImpl());
    }

    public static enum InteractiveModes implements IntegerValuedEnum
    {
        AUTO(InteractiveModes.getAUTO()),
        FORCE_INTERACTION(InteractiveModes.getFORCEINTERACTION()),
        FORCE_STILL(InteractiveModes.getFORCESTILL()),
        DISABLED(InteractiveModes.getDISABLED());

        private int value;

        private static native int getDISABLEDNative();

        private static int getFORCESTILL() {
            JniInitializer.checkInit();
            return InteractiveModes.getFORCESTILLNative();
        }

        private InteractiveModes(int n2) {
            this.value = n2;
        }

        private static int getDISABLED() {
            JniInitializer.checkInit();
            return InteractiveModes.getDISABLEDNative();
        }

        private static native int getFORCESTILLNative();

        private static int getAUTO() {
            JniInitializer.checkInit();
            return InteractiveModes.getAUTONative();
        }

        private static native int getAUTONative();

        private static int getFORCEINTERACTION() {
            JniInitializer.checkInit();
            return InteractiveModes.getFORCEINTERACTIONNative();
        }

        private static native int getFORCEINTERACTIONNative();

        public static InteractiveModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(InteractiveModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

