/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFUShort;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoNurbsProperty
extends SoNode {
    public final SoSFBitMask<DrawStyles> drawStyle;
    public final SoSFInt32 numSamplePoints;
    public final SoSFColor color;
    public final SoSFUShort isoParamCurvesPattern;
    public final SoSFEnum<TessellationTypes> tessellationType;
    public final SoSFFloat tessellationDistance;
    public final SoSFFloat tessellationAngle;

    private static native long ctorImpl();

    protected SoNurbsProperty(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.drawStyle = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "drawStyle"), DrawStyles.class);
        this.numSamplePoints = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "numSamplePoints"));
        this.color = ObjectManager.getManagedObjectFor(SoSFColor.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "color"));
        this.isoParamCurvesPattern = ObjectManager.getManagedObjectFor(SoSFUShort.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "isoParamCurvesPattern"));
        this.tessellationType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "tessellationType"), TessellationTypes.class);
        this.tessellationDistance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "tessellationDistance"));
        this.tessellationAngle = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoNurbsProperty.getFieldHandle(this.getNativeResourceHandle(), "tessellationAngle"));
    }

    static native String getClassTypeId();

    public SoNurbsProperty() {
        this(Inventor.ConstructorCommand.CreateInstance, SoNurbsProperty.ctorImpl());
    }

    public static enum DrawStyles implements IntegerValuedEnum
    {
        NORMAL(DrawStyles.getNORMAL()),
        BOUNDARIES_AND_TRIM_CURVES(DrawStyles.getBOUNDARIESANDTRIMCURVES()),
        CENTRAL_ISO_PARAM_CURVES(DrawStyles.getCENTRALISOPARAMCURVES());

        private int value;

        private static native int getCENTRALISOPARAMCURVESNative();

        private static int getCENTRALISOPARAMCURVES() {
            JniInitializer.checkInit();
            return DrawStyles.getCENTRALISOPARAMCURVESNative();
        }

        private DrawStyles(int n2) {
            this.value = n2;
        }

        private static int getBOUNDARIESANDTRIMCURVES() {
            JniInitializer.checkInit();
            return DrawStyles.getBOUNDARIESANDTRIMCURVESNative();
        }

        private static native int getNORMALNative();

        private static int getNORMAL() {
            JniInitializer.checkInit();
            return DrawStyles.getNORMALNative();
        }

        private static native int getBOUNDARIESANDTRIMCURVESNative();

        public static DrawStyles valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DrawStyles.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum TessellationTypes implements IntegerValuedEnum
    {
        CONSTANT(TessellationTypes.getCONSTANT()),
        ADAPTIVE(TessellationTypes.getADAPTIVE());

        private int value;

        private static int getADAPTIVE() {
            JniInitializer.checkInit();
            return TessellationTypes.getADAPTIVENative();
        }

        private TessellationTypes(int n2) {
            this.value = n2;
        }

        private static native int getADAPTIVENative();

        private static native int getCONSTANTNative();

        private static int getCONSTANT() {
            JniInitializer.checkInit();
            return TessellationTypes.getCONSTANTNative();
        }

        public static TessellationTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TessellationTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

