/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFNode;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoComputeShader;
import com.openinventor.inventor.nodes.SoFragmentShader;
import com.openinventor.inventor.nodes.SoGeometryShader;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoShaderObject;
import com.openinventor.inventor.nodes.SoShaderParameterImage;
import com.openinventor.inventor.nodes.SoTessellationControlShader;
import com.openinventor.inventor.nodes.SoTessellationEvaluationShader;
import com.openinventor.inventor.nodes.SoTexture;
import com.openinventor.inventor.nodes.SoVertexShader;

public class SoShaderProgram
extends SoNode {
    public final SoMFNode shaderObject;
    public final SoSFEnum<GeometryInputTypes> geometryInputType;
    public final SoSFEnum<GeometryOutputTypes> geometryOutputType;
    public final SoSFBool vertexProgramTwoSide;
    public final SoSFBool shadowShader;
    public final SoSFInt32 maxGeometryOutputVertices;
    public final SoSFBool generateTransparency;
    public final SoSFInt32 patchLength;
    public final SoMFNode bufferObjects;
    public final SoMFNode images;

    private static native long setComputeShaderImpl(long var0, int var2, String var3, int var4);

    private static native long getTessellationControlShaderImpl(long var0, int var2);

    private static native long setFragmentShaderImpl(long var0, int var2, String var3, int var4);

    private static native long setGeometryShaderImpl(long var0, int var2, String var3, int var4);

    private static native long setVertexShaderImpl(long var0, int var2, String var3, int var4);

    private static native long addShaderParameterImageImpl(long var0, String var2, long var3);

    private static native long getTessellationEvaluationShaderImpl(long var0, int var2);

    private static native long setTessellationControlShaderImpl(long var0, int var2, String var3, int var4);

    private static native long ctorImpl();

    private static native long setTessellationEvaluationShaderImpl(long var0, int var2, String var3, int var4);

    private static native int getNumReservedTexturesImpl();

    private static native long getGeometryShaderImpl(long var0, int var2);

    private static native long getVertexShaderImpl(long var0, int var2);

    private static native long getFragmentShaderImpl(long var0, int var2);

    protected SoShaderProgram(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.shaderObject = ObjectManager.getManagedObjectFor(SoMFNode.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "shaderObject"));
        this.geometryInputType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "geometryInputType"), GeometryInputTypes.class);
        this.geometryOutputType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "geometryOutputType"), GeometryOutputTypes.class);
        this.vertexProgramTwoSide = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "vertexProgramTwoSide"));
        this.shadowShader = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "shadowShader"));
        this.maxGeometryOutputVertices = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "maxGeometryOutputVertices"));
        this.generateTransparency = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "generateTransparency"));
        this.patchLength = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "patchLength"));
        this.bufferObjects = ObjectManager.getManagedObjectFor(SoMFNode.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "bufferObjects"));
        this.images = ObjectManager.getManagedObjectFor(SoMFNode.class, SoShaderProgram.getFieldHandle(this.getNativeResourceHandle(), "images"));
    }

    static native String getClassTypeId();

    public SoFragmentShader setFragmentShader(int n, String string) {
        return this.setFragmentShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public SoVertexShader setVertexShader(int n, String string) {
        return this.setVertexShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public SoTessellationControlShader setTessellationControlShader(int n, String string) {
        return this.setTessellationControlShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public SoTessellationEvaluationShader setTessellationEvaluationShader(int n, String string) {
        return this.setTessellationEvaluationShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public SoGeometryShader setGeometryShader(int n, String string) {
        return this.setGeometryShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public SoComputeShader setComputeShader(int n, String string) {
        return this.setComputeShader(n, string, SoShaderObject.SourceTypes.valueOf(SoShaderObject.SourceTypes.FILENAME.getValue()));
    }

    public static int getNumReservedTextures() {
        return SoShaderProgram.getNumReservedTexturesImpl();
    }

    public SoTessellationEvaluationShader getTessellationEvaluationShader(int n) {
        return ObjectManager.getManagedObjectFor(SoTessellationEvaluationShader.class, SoShaderProgram.getTessellationEvaluationShaderImpl(this.getNativeResourceHandle(), n));
    }

    public SoShaderProgram() {
        this(Inventor.ConstructorCommand.CreateInstance, SoShaderProgram.ctorImpl());
    }

    public SoTessellationControlShader getTessellationControlShader(int n) {
        return ObjectManager.getManagedObjectFor(SoTessellationControlShader.class, SoShaderProgram.getTessellationControlShaderImpl(this.getNativeResourceHandle(), n));
    }

    public SoComputeShader setComputeShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoComputeShader.class, SoShaderProgram.setComputeShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public SoShaderParameterImage addShaderParameterImage(String string, SoTexture soTexture) {
        return ObjectManager.getManagedObjectFor(SoShaderParameterImage.class, SoShaderProgram.addShaderParameterImageImpl(this.getNativeResourceHandle(), string, soTexture != null ? soTexture.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SoTessellationControlShader setTessellationControlShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoTessellationControlShader.class, SoShaderProgram.setTessellationControlShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public SoTessellationEvaluationShader setTessellationEvaluationShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoTessellationEvaluationShader.class, SoShaderProgram.setTessellationEvaluationShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public SoGeometryShader setGeometryShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoGeometryShader.class, SoShaderProgram.setGeometryShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public SoVertexShader getVertexShader(int n) {
        return ObjectManager.getManagedObjectFor(SoVertexShader.class, SoShaderProgram.getVertexShaderImpl(this.getNativeResourceHandle(), n));
    }

    public SoFragmentShader getFragmentShader(int n) {
        return ObjectManager.getManagedObjectFor(SoFragmentShader.class, SoShaderProgram.getFragmentShaderImpl(this.getNativeResourceHandle(), n));
    }

    public SoGeometryShader getGeometryShader(int n) {
        return ObjectManager.getManagedObjectFor(SoGeometryShader.class, SoShaderProgram.getGeometryShaderImpl(this.getNativeResourceHandle(), n));
    }

    public SoVertexShader setVertexShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoVertexShader.class, SoShaderProgram.setVertexShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public SoFragmentShader setFragmentShader(int n, String string, SoShaderObject.SourceTypes sourceTypes) {
        return ObjectManager.getManagedObjectFor(SoFragmentShader.class, SoShaderProgram.setFragmentShaderImpl(this.getNativeResourceHandle(), n, string, sourceTypes.getValue()));
    }

    public static enum GeometryInputTypes implements IntegerValuedEnum
    {
        POINTS_INPUT(GeometryInputTypes.getPOINTSINPUT()),
        LINES_INPUT(GeometryInputTypes.getLINESINPUT()),
        TRIANGLES_INPUT(GeometryInputTypes.getTRIANGLESINPUT());

        private int value;

        private static native int getTRIANGLESINPUTNative();

        private static int getTRIANGLESINPUT() {
            JniInitializer.checkInit();
            return GeometryInputTypes.getTRIANGLESINPUTNative();
        }

        private GeometryInputTypes(int n2) {
            this.value = n2;
        }

        private static int getLINESINPUT() {
            JniInitializer.checkInit();
            return GeometryInputTypes.getLINESINPUTNative();
        }

        private static native int getPOINTSINPUTNative();

        private static int getPOINTSINPUT() {
            JniInitializer.checkInit();
            return GeometryInputTypes.getPOINTSINPUTNative();
        }

        private static native int getLINESINPUTNative();

        public static GeometryInputTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(GeometryInputTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum GeometryOutputTypes implements IntegerValuedEnum
    {
        POINTS_OUTPUT(GeometryOutputTypes.getPOINTSOUTPUT()),
        LINE_STRIP_OUTPUT(GeometryOutputTypes.getLINESTRIPOUTPUT()),
        TRIANGLE_STRIP_OUTPUT(GeometryOutputTypes.getTRIANGLESTRIPOUTPUT());

        private int value;

        private static native int getTRIANGLESTRIPOUTPUTNative();

        private static int getTRIANGLESTRIPOUTPUT() {
            JniInitializer.checkInit();
            return GeometryOutputTypes.getTRIANGLESTRIPOUTPUTNative();
        }

        private GeometryOutputTypes(int n2) {
            this.value = n2;
        }

        private static int getLINESTRIPOUTPUT() {
            JniInitializer.checkInit();
            return GeometryOutputTypes.getLINESTRIPOUTPUTNative();
        }

        private static native int getPOINTSOUTPUTNative();

        private static int getPOINTSOUTPUT() {
            JniInitializer.checkInit();
            return GeometryOutputTypes.getPOINTSOUTPUTNative();
        }

        private static native int getLINESTRIPOUTPUTNative();

        public static GeometryOutputTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(GeometryOutputTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

