/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoUniformShaderParameter;

public class SoShaderStateMatrixParameter
extends SoUniformShaderParameter {
    public final SoSFEnum<MatrixTypes> matrixType;
    public final SoSFEnum<MatrixTransforms> matrixTransform;

    private static native long ctorImpl();

    protected SoShaderStateMatrixParameter(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.matrixType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderStateMatrixParameter.getFieldHandle(this.getNativeResourceHandle(), "matrixType"), MatrixTypes.class);
        this.matrixTransform = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderStateMatrixParameter.getFieldHandle(this.getNativeResourceHandle(), "matrixTransform"), MatrixTransforms.class);
    }

    static native String getClassTypeId();

    public SoShaderStateMatrixParameter() {
        this(Inventor.ConstructorCommand.CreateInstance, SoShaderStateMatrixParameter.ctorImpl());
    }

    public static enum MatrixTypes implements IntegerValuedEnum
    {
        MODELVIEW(MatrixTypes.getMODELVIEW()),
        PROJECTION(MatrixTypes.getPROJECTION()),
        TEXTURE(MatrixTypes.getTEXTURE()),
        MODELVIEW_PROJECTION(MatrixTypes.getMODELVIEWPROJECTION());

        private int value;

        private static native int getMODELVIEWPROJECTIONNative();

        private static int getTEXTURE() {
            JniInitializer.checkInit();
            return MatrixTypes.getTEXTURENative();
        }

        private MatrixTypes(int n2) {
            this.value = n2;
        }

        private static int getMODELVIEWPROJECTION() {
            JniInitializer.checkInit();
            return MatrixTypes.getMODELVIEWPROJECTIONNative();
        }

        private static native int getTEXTURENative();

        private static int getMODELVIEW() {
            JniInitializer.checkInit();
            return MatrixTypes.getMODELVIEWNative();
        }

        private static native int getMODELVIEWNative();

        private static int getPROJECTION() {
            JniInitializer.checkInit();
            return MatrixTypes.getPROJECTIONNative();
        }

        private static native int getPROJECTIONNative();

        public static MatrixTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(MatrixTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum MatrixTransforms implements IntegerValuedEnum
    {
        IDENTITY(MatrixTransforms.getIDENTITY()),
        TRANSPOSE(MatrixTransforms.getTRANSPOSE()),
        INVERSE(MatrixTransforms.getINVERSE()),
        INVERSE_TRANSPOSE(MatrixTransforms.getINVERSETRANSPOSE());

        private int value;

        private static native int getINVERSETRANSPOSENative();

        private static int getINVERSE() {
            JniInitializer.checkInit();
            return MatrixTransforms.getINVERSENative();
        }

        private MatrixTransforms(int n2) {
            this.value = n2;
        }

        private static int getINVERSETRANSPOSE() {
            JniInitializer.checkInit();
            return MatrixTransforms.getINVERSETRANSPOSENative();
        }

        private static native int getINVERSENative();

        private static int getIDENTITY() {
            JniInitializer.checkInit();
            return MatrixTransforms.getIDENTITYNative();
        }

        private static native int getIDENTITYNative();

        private static int getTRANSPOSE() {
            JniInitializer.checkInit();
            return MatrixTransforms.getTRANSPOSENative();
        }

        private static native int getTRANSPOSENative();

        public static MatrixTransforms valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(MatrixTransforms.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

