/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFString;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;

public class SoText3
extends SoShape {
    public final SoMFString string;
    public final SoSFFloat spacing;
    public final SoSFBitMask<PartType> parts;
    public final SoSFEnum<Justifications> justification;

    private static native long ctorImpl();

    protected SoText3(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.string = ObjectManager.getManagedObjectFor(SoMFString.class, SoText3.getFieldHandle(this.getNativeResourceHandle(), "string"));
        this.spacing = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoText3.getFieldHandle(this.getNativeResourceHandle(), "spacing"));
        this.parts = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoText3.getFieldHandle(this.getNativeResourceHandle(), "parts"), PartType.class);
        this.justification = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoText3.getFieldHandle(this.getNativeResourceHandle(), "justification"), Justifications.class);
    }

    static native String getClassTypeId();

    public SoText3() {
        this(Inventor.ConstructorCommand.CreateInstance, SoText3.ctorImpl());
    }

    public static enum PartType implements IntegerValuedEnum
    {
        FRONT(PartType.getFRONT()),
        SIDES(PartType.getSIDES()),
        BACK(PartType.getBACK()),
        ALL(PartType.getALL());

        private int value;

        private static native int getALLNative();

        private static int getBACK() {
            JniInitializer.checkInit();
            return PartType.getBACKNative();
        }

        private PartType(int n2) {
            this.value = n2;
        }

        private static int getALL() {
            JniInitializer.checkInit();
            return PartType.getALLNative();
        }

        private static native int getBACKNative();

        private static int getFRONT() {
            JniInitializer.checkInit();
            return PartType.getFRONTNative();
        }

        private static native int getFRONTNative();

        private static int getSIDES() {
            JniInitializer.checkInit();
            return PartType.getSIDESNative();
        }

        private static native int getSIDESNative();

        public static PartType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PartType.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum Justifications implements IntegerValuedEnum
    {
        LEFT(Justifications.getLEFT()),
        CENTER(Justifications.getCENTER()),
        RIGHT(Justifications.getRIGHT()),
        INHERITED(Justifications.getINHERITED());

        private int value;

        private static native int getINHERITEDNative();

        private static int getRIGHT() {
            JniInitializer.checkInit();
            return Justifications.getRIGHTNative();
        }

        private Justifications(int n2) {
            this.value = n2;
        }

        private static int getINHERITED() {
            JniInitializer.checkInit();
            return Justifications.getINHERITEDNative();
        }

        private static native int getRIGHTNative();

        private static int getLEFT() {
            JniInitializer.checkInit();
            return Justifications.getLEFTNative();
        }

        private static native int getLEFTNative();

        private static int getCENTER() {
            JniInitializer.checkInit();
            return Justifications.getCENTERNative();
        }

        private static native int getCENTERNative();

        public static Justifications valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Justifications.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

