/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoTransformation;

public class SoUnits
extends SoTransformation {
    public final SoSFEnum<UnitsType> units;

    private static native long ctorImpl();

    protected SoUnits(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.units = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoUnits.getFieldHandle(this.getNativeResourceHandle(), "units"), UnitsType.class);
    }

    static native String getClassTypeId();

    public SoUnits() {
        this(Inventor.ConstructorCommand.CreateInstance, SoUnits.ctorImpl());
    }

    public static enum UnitsType implements IntegerValuedEnum
    {
        METERS(UnitsType.getMETERS()),
        CENTIMETERS(UnitsType.getCENTIMETERS()),
        MILLIMETERS(UnitsType.getMILLIMETERS()),
        MICROMETERS(UnitsType.getMICROMETERS()),
        MICRONS(UnitsType.getMICRONS()),
        NANOMETERS(UnitsType.getNANOMETERS()),
        ANGSTROMS(UnitsType.getANGSTROMS()),
        KILOMETERS(UnitsType.getKILOMETERS()),
        FEET(UnitsType.getFEET()),
        INCHES(UnitsType.getINCHES()),
        POINTS(UnitsType.getPOINTS()),
        YARDS(UnitsType.getYARDS()),
        MILES(UnitsType.getMILES()),
        NAUTICAL_MILES(UnitsType.getNAUTICALMILES());

        private int value;

        private static int getINCHES() {
            JniInitializer.checkInit();
            return UnitsType.getINCHESNative();
        }

        private static native int getPOINTSNative();

        private static int getPOINTS() {
            JniInitializer.checkInit();
            return UnitsType.getPOINTSNative();
        }

        private static native int getINCHESNative();

        private static int getKILOMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getKILOMETERSNative();
        }

        private static native int getFEETNative();

        private static int getFEET() {
            JniInitializer.checkInit();
            return UnitsType.getFEETNative();
        }

        private static native int getNAUTICALMILESNative();

        private static int getNAUTICALMILES() {
            JniInitializer.checkInit();
            return UnitsType.getNAUTICALMILESNative();
        }

        private UnitsType(int n2) {
            this.value = n2;
        }

        private static int getMILES() {
            JniInitializer.checkInit();
            return UnitsType.getMILESNative();
        }

        private static native int getYARDSNative();

        private static int getYARDS() {
            JniInitializer.checkInit();
            return UnitsType.getYARDSNative();
        }

        private static native int getMILESNative();

        private static native int getKILOMETERSNative();

        private static native int getMILLIMETERSNative();

        private static int getMILLIMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getMILLIMETERSNative();
        }

        private static native int getMICROMETERSNative();

        private static int getCENTIMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getCENTIMETERSNative();
        }

        private static native int getMETERSNative();

        private static int getMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getMETERSNative();
        }

        private static native int getCENTIMETERSNative();

        private static int getNANOMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getNANOMETERSNative();
        }

        private static native int getANGSTROMSNative();

        private static int getANGSTROMS() {
            JniInitializer.checkInit();
            return UnitsType.getANGSTROMSNative();
        }

        private static native int getNANOMETERSNative();

        private static int getMICROMETERS() {
            JniInitializer.checkInit();
            return UnitsType.getMICROMETERSNative();
        }

        private static native int getMICRONSNative();

        private static int getMICRONS() {
            JniInitializer.checkInit();
            return UnitsType.getMICRONSNative();
        }

        public static UnitsType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(UnitsType.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

