/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.projection;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoProjection;

public class SbProjection
extends Inventor {
    private static native boolean getProjectedBoundingBoxImpl(long var0, float[] var2);

    private static native boolean getStringParameterImpl(long var0, int var2, String[] var3);

    private static native void projectImpl(long var0, float[] var2);

    private static native void setParameterImpl1(long var0, int var2, float var3);

    private static native void inverseImpl(long var0, float[] var2);

    private static native boolean getFloatParameterImpl(long var0, int var2, float[] var3);

    private static native void setNumFloatParametersImpl(long var0, int var2);

    private static native long getProjectionNodeImpl(long var0);

    private static native void setNumStringParametersImpl(long var0, int var2);

    private static native int getNumFloatParametersImpl(long var0);

    private static native int getNumStringParametersImpl(long var0);

    private static native long ctorImpl2(long var0);

    private static native long ctorImpl();

    private static native long ctorImpl1(long var0);

    private static native void setParameterImpl(long var0, int var2, String var3);

    private static native void exitImpl(long var0);

    private static native void initImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbProjection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SbVec3f inverse() {
        SbVec3f sbVec3f = new SbVec3f();
        SbProjection.inverseImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        return sbVec3f;
    }

    public void exit() {
        SbProjection.exitImpl(this.getNativeResourceHandle());
    }

    public void init() {
        SbProjection.initImpl(this.getNativeResourceHandle());
    }

    public SbProjection() {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImpl());
    }

    public SbProjection(SoProjection soProjection) {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImpl1(soProjection != null ? soProjection.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SbProjection(SbProjection sbProjection) {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImpl2(sbProjection != null ? sbProjection.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SbBox3f getProjectedBoundingBox() {
        SbBox3f sbBox3f = new SbBox3f();
        boolean bl = false;
        bl = SbProjection.getProjectedBoundingBoxImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null);
        if (bl) {
            return sbBox3f;
        }
        return null;
    }

    public void setNumFloatParameters(int n) {
        SbProjection.setNumFloatParametersImpl(this.getNativeResourceHandle(), n);
    }

    public SoProjection getProjectionNode() {
        return ObjectManager.getManagedObjectFor(SoProjection.class, SbProjection.getProjectionNodeImpl(this.getNativeResourceHandle()));
    }

    public void setParameter(int n, String string) {
        SbProjection.setParameterImpl(this.getNativeResourceHandle(), n, string);
    }

    public void setParameter(int n, float f) {
        SbProjection.setParameterImpl1(this.getNativeResourceHandle(), n, f);
    }

    public void setNumStringParameters(int n) {
        SbProjection.setNumStringParametersImpl(this.getNativeResourceHandle(), n);
    }

    public int getNumStringParameters() {
        return SbProjection.getNumStringParametersImpl(this.getNativeResourceHandle());
    }

    public SbVec3f project() {
        SbVec3f sbVec3f = new SbVec3f();
        SbProjection.projectImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        return sbVec3f;
    }

    public float getFloatParameter(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        bl = SbProjection.getFloatParameterImpl(this.getNativeResourceHandle(), n, fArray);
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public String getStringParameter(int n) {
        String[] stringArray = new String[1];
        boolean bl = false;
        bl = SbProjection.getStringParameterImpl(this.getNativeResourceHandle(), n, stringArray);
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    public int getNumFloatParameters() {
        return SbProjection.getNumFloatParametersImpl(this.getNativeResourceHandle());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

