/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.simplifier;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoSimplifier
extends Inventor {
    private static native void setVertexImpl(long var0, float[] var2);

    private static native long simplifyImpl(long var0, float var2);

    private static native void setColorImpl(long var0, long var2);

    private static native void setDataImpl(long var0, int var2, float[] var3);

    private static native void setNormalImpl(long var0, float[] var2);

    private static native void endShapeImpl(long var0);

    private static native void setVerbosityImpl(long var0, boolean var2);

    private static native boolean getVerbosityImpl(long var0);

    private static native int getNumTrianglesImpl(long var0);

    private static native void clearImpl(long var0);

    private static native void beginShapeImpl(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoSimplifier(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void beginShape(ShapeTypes shapeTypes) {
        SoSimplifier.beginShapeImpl(this.getNativeResourceHandle(), shapeTypes.getValue());
    }

    public void setVerbosity(boolean bl) {
        SoSimplifier.setVerbosityImpl(this.getNativeResourceHandle(), bl);
    }

    public void setColor(long l) {
        SoSimplifier.setColorImpl(this.getNativeResourceHandle(), l);
    }

    public boolean getVerbosity() {
        return SoSimplifier.getVerbosityImpl(this.getNativeResourceHandle());
    }

    public int getNumTriangles() {
        return SoSimplifier.getNumTrianglesImpl(this.getNativeResourceHandle());
    }

    public SoNode simplify(float f) {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoSimplifier.simplifyImpl(this.getNativeResourceHandle(), f));
    }

    public void setNormal(SbVec3f sbVec3f) {
        SoSimplifier.setNormalImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
    }

    public void setData(int n, float[] fArray) {
        SoSimplifier.setDataImpl(this.getNativeResourceHandle(), n, fArray);
    }

    public void endShape() {
        SoSimplifier.endShapeImpl(this.getNativeResourceHandle());
    }

    public void clear() {
        SoSimplifier.clearImpl(this.getNativeResourceHandle());
    }

    public void setVertex(SbVec3f sbVec3f) {
        SoSimplifier.setVertexImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        TRIANGLES(ShapeTypes.getTRIANGLES()),
        TRIANGLE_STRIP(ShapeTypes.getTRIANGLESTRIP()),
        TRIANGLE_FAN(ShapeTypes.getTRIANGLEFAN());

        private int value;

        private static native int getTRIANGLEFANNative();

        private static int getTRIANGLEFAN() {
            JniInitializer.checkInit();
            return ShapeTypes.getTRIANGLEFANNative();
        }

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static int getTRIANGLESTRIP() {
            JniInitializer.checkInit();
            return ShapeTypes.getTRIANGLESTRIPNative();
        }

        private static native int getTRIANGLESNative();

        private static int getTRIANGLES() {
            JniInitializer.checkInit();
            return ShapeTypes.getTRIANGLESNative();
        }

        private static native int getTRIANGLESTRIPNative();

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

