/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.touch;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.gestures.recognizers.SoGestureRecognizer;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import java.util.ArrayList;
import java.util.Vector;

public class SoTouchManager
extends Inventor {
    private Vector<SoGestureRecognizer> m_recognizerReferences = new Vector();

    private static native void addRecognizerImpl(long var0, long var2);

    private static native void removeRecognizerImpl(long var0, long var2);

    public void addRecognizer(SoGestureRecognizer soGestureRecognizer) {
        if (soGestureRecognizer != null) {
            this.m_recognizerReferences.add(soGestureRecognizer);
        }
        SoTouchManager.addRecognizerImpl(this.getNativeResourceHandle(), soGestureRecognizer != null ? soGestureRecognizer.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void removeRecognizer(SoGestureRecognizer soGestureRecognizer) {
        this.m_recognizerReferences.remove(soGestureRecognizer);
        SoTouchManager.removeRecognizerImpl(this.getNativeResourceHandle(), soGestureRecognizer != null ? soGestureRecognizer.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    private static native long[] getRecognizerListImpl(long var0);

    private static native void setMaxSimultaneousFingersImpl(long var0, int var2);

    private static native int getMaxSimultaneousFingersImpl(long var0);

    private static native int getFingerNumberImpl(long var0);

    private static native long[] getTouchDownEventImpl(long var0, long var2, float[] var4, long var5);

    private static native void removeDefaultRecognizersImpl(long var0);

    private static native void setTouchScreenAvailabilityImpl(long var0, boolean var2);

    private static native boolean isTouchScreenAvailableImpl(long var0);

    private static native float getThresholdImpl(long var0);

    private static native void setThresholdImpl(long var0, float var2);

    private static native void addDefaultRecognizersImpl(long var0);

    private static native long updateAndProcessTouchEventImpl(long var0, long var2, int var4, float[] var5, long var6);

    private static native long ctorImpl();

    private static native long getEventByIdImpl(long var0, long var2);

    private static native long[] getAllFingerIdsImpl(long var0);

    private static native long[] getTouchUpEventImpl(long var0, long var2, float[] var4, long var5);

    private static native long[] getTouchMoveEventImpl(long var0, long var2, float[] var4, long var5);

    private static native long ctorImpl1(long var0);

    private static native long getEventbyIndexImpl(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoTouchManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Deprecated(since="9.5.0.0")
    public SoTouchManager(SoSceneManager soSceneManager) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTouchManager.ctorImpl1(soSceneManager != null ? soSceneManager.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SoTouchEvent getEventbyIndex(int n) {
        return ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.getEventbyIndexImpl(this.getNativeResourceHandle(), n));
    }

    public ArrayList<SoEvent> getTouchMoveEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        lArray = SoTouchManager.getTouchMoveEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    public long[] getAllFingerIds() {
        long[] lArray = null;
        lArray = SoTouchManager.getAllFingerIdsImpl(this.getNativeResourceHandle());
        return lArray;
    }

    public void setTouchScreenAvailability(boolean bl) {
        SoTouchManager.setTouchScreenAvailabilityImpl(this.getNativeResourceHandle(), bl);
    }

    public SoTouchManager() {
        this(Inventor.ConstructorCommand.CreateInstance, SoTouchManager.ctorImpl());
    }

    @Deprecated(since="9.5.0.0")
    public SoTouchEvent updateAndProcessTouchEvent(long l, SoTouchEvent.States states, SbVec2f sbVec2f, SbTime sbTime) {
        return ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.updateAndProcessTouchEventImpl(this.getNativeResourceHandle(), l, states.getValue(), sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SoTouchEvent getEventById(long l) {
        return ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.getEventByIdImpl(this.getNativeResourceHandle(), l));
    }

    public int getFingerNumber() {
        return SoTouchManager.getFingerNumberImpl(this.getNativeResourceHandle());
    }

    public void removeDefaultRecognizers() {
        SoTouchManager.removeDefaultRecognizersImpl(this.getNativeResourceHandle());
    }

    public void setThreshold(float f) {
        SoTouchManager.setThresholdImpl(this.getNativeResourceHandle(), f);
    }

    public float getThreshold() {
        return SoTouchManager.getThresholdImpl(this.getNativeResourceHandle());
    }

    public boolean isTouchScreenAvailable() {
        return SoTouchManager.isTouchScreenAvailableImpl(this.getNativeResourceHandle());
    }

    public void addDefaultRecognizers() {
        SoTouchManager.addDefaultRecognizersImpl(this.getNativeResourceHandle());
    }

    public int getMaxSimultaneousFingers() {
        return SoTouchManager.getMaxSimultaneousFingersImpl(this.getNativeResourceHandle());
    }

    public ArrayList<SoEvent> getTouchUpEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        lArray = SoTouchManager.getTouchUpEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    public ArrayList<SoEvent> getTouchDownEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        lArray = SoTouchManager.getTouchDownEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    public ArrayList<SoGestureRecognizer> getRecognizerList() {
        long[] lArray = null;
        lArray = SoTouchManager.getRecognizerListImpl(this.getNativeResourceHandle());
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoGestureRecognizer> arrayList = new ArrayList<SoGestureRecognizer>(lArray.length);
        for (long l : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoGestureRecognizer.class, l));
        }
        return arrayList;
    }

    public void setMaxSimultaneousFingers(int n) {
        SoTouchManager.setMaxSimultaneousFingersImpl(this.getNativeResourceHandle(), n);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

