/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class RenderAreaExaminer
extends RenderAreaInteractive
implements IRenderAreaExaminer {
    private static final Cursor SEEK_CURSOR = RenderAreaExaminer.createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorSeek.png", "seek cursor");
    private static final Cursor VIEWING_CURSOR = RenderAreaExaminer.createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorCurvedHand.png", "hand cursor");
    private SceneExaminer m_examinerRootSceneGraph;

    public RenderAreaExaminer() {
        super(false);
        this.init();
    }

    public RenderAreaExaminer(GLCapabilities gLCapabilities) {
        super(false, gLCapabilities);
        this.init();
    }

    private void init() {
        SoPreferences.setValue((String)"OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", (String)"false");
        this.m_examinerRootSceneGraph = new SceneExaminer();
        this.m_rootSceneGraph = this.m_examinerRootSceneGraph;
        this.buildSceneGraph();
        this.updateInteractionCursor();
        this.m_examinerRootSceneGraph.addInteractionModeListener(new SceneExaminer.InteractionModeListener(){

            public void seekModeChanged(boolean bl) {
                RenderAreaExaminer.this.updateSeekCursor(bl);
            }

            public void interactionModeChanged(SceneExaminer.InteractionMode interactionMode) {
                RenderAreaExaminer.this.updateInteractionCursor();
            }
        });
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        this.m_renderAreaCore.getSceneManager().setAutoInteractiveMode(false);
    }

    @Override
    public void setSeekMode(boolean bl) {
        this.m_examinerRootSceneGraph.setSeekMode(bl);
    }

    @Override
    public void setNavigationMode(SceneExaminer.NavigationMode navigationMode) {
        this.m_examinerRootSceneGraph.setNavigationMode(navigationMode);
    }

    @Override
    public SceneExaminer.NavigationMode getNavigationMode() {
        return this.m_examinerRootSceneGraph.getNavigationMode();
    }

    @Override
    public void setInteractionMode(SceneExaminer.InteractionMode interactionMode) {
        this.m_examinerRootSceneGraph.setInteractionMode(interactionMode);
    }

    @Override
    public SceneExaminer.InteractionMode getInteractionMode() {
        return this.m_examinerRootSceneGraph.getInteractionMode();
    }

    @Override
    public void addInteractionModeListener(SceneExaminer.InteractionModeListener interactionModeListener) {
        this.m_examinerRootSceneGraph.addInteractionModeListener(interactionModeListener);
    }

    @Override
    public void removeInteractionModeListener(SceneExaminer.InteractionModeListener interactionModeListener) {
        this.m_examinerRootSceneGraph.removeInteractionModeListener(interactionModeListener);
    }

    @Override
    @Deprecated
    public SceneExaminer getRootSceneGraph() {
        return this.m_examinerRootSceneGraph;
    }

    @Override
    public SceneExaminer getSceneInteractor() {
        return this.m_examinerRootSceneGraph;
    }

    private void updateSeekCursor(boolean bl) {
        if (bl) {
            this.setCursor(SEEK_CURSOR);
        } else {
            this.updateInteractionCursor();
        }
    }

    private void updateInteractionCursor() {
        if (this.getInteractionMode() == SceneExaminer.InteractionMode.NAVIGATION) {
            this.setCursor(VIEWING_CURSOR);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static Cursor createCursor(String string, String string2) {
        return Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(RenderAreaExaminer.class.getResource(string)).getImage(), new Point(16, 16), string2);
    }
}

