/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.newt.renderareas;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.newt.Display;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.util.PNGPixelRect;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public class RenderAreaExaminer
extends RenderAreaInteractive
implements IRenderAreaExaminer {
    private SceneExaminer m_examinerRootSceneGraph;
    private Display.PointerIcon m_seekIcon;
    private Display.PointerIcon m_viewingIcon;

    public RenderAreaExaminer() {
        this(false);
    }

    public RenderAreaExaminer(boolean bl) {
        super(false, bl);
        SoPreferences.setValue((String)"OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", (String)"false");
        this.m_examinerRootSceneGraph = new SceneExaminer();
        this.m_rootSceneGraph = this.m_examinerRootSceneGraph;
        this.buildSceneGraph();
        this.m_seekIcon = null;
        this.m_viewingIcon = null;
        this.m_examinerRootSceneGraph.addInteractionModeListener(new SceneExaminer.InteractionModeListener(){

            public void seekModeChanged(boolean bl) {
                RenderAreaExaminer.this.updateSeekCursor(bl);
            }

            public void interactionModeChanged(SceneExaminer.InteractionMode interactionMode) {
                RenderAreaExaminer.this.updateInteractionCursor();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && RenderAreaExaminer.this.isShowing()) {
                    RenderAreaExaminer.this.updateInteractionCursor();
                }
            }
        });
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        this.m_renderAreaCore.getSceneManager().setAutoInteractiveMode(false);
    }

    @Override
    public void setSeekMode(boolean bl) {
        this.m_examinerRootSceneGraph.setSeekMode(bl);
    }

    @Override
    public void setNavigationMode(SceneExaminer.NavigationMode navigationMode) {
        this.m_examinerRootSceneGraph.setNavigationMode(navigationMode);
    }

    @Override
    public SceneExaminer.NavigationMode getNavigationMode() {
        return this.m_examinerRootSceneGraph.getNavigationMode();
    }

    @Override
    public void setInteractionMode(SceneExaminer.InteractionMode interactionMode) {
        this.m_examinerRootSceneGraph.setInteractionMode(interactionMode);
    }

    @Override
    public SceneExaminer.InteractionMode getInteractionMode() {
        return this.m_examinerRootSceneGraph.getInteractionMode();
    }

    @Override
    public void addInteractionModeListener(SceneExaminer.InteractionModeListener interactionModeListener) {
        this.m_examinerRootSceneGraph.addInteractionModeListener(interactionModeListener);
    }

    @Override
    public void removeInteractionModeListener(SceneExaminer.InteractionModeListener interactionModeListener) {
        this.m_examinerRootSceneGraph.removeInteractionModeListener(interactionModeListener);
    }

    @Override
    @Deprecated
    public SceneExaminer getRootSceneGraph() {
        return this.m_examinerRootSceneGraph;
    }

    @Override
    public SceneExaminer getSceneInteractor() {
        return this.m_examinerRootSceneGraph;
    }

    private void updateSeekCursor(boolean bl) {
        try {
            if (bl) {
                if (this.m_seekIcon == null) {
                    this.m_seekIcon = this.createSeekCursor();
                }
                this.m_glWindow.setPointerIcon(this.m_seekIcon);
            } else {
                this.updateInteractionCursor();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void updateInteractionCursor() {
        try {
            if (this.getInteractionMode() == SceneExaminer.InteractionMode.NAVIGATION) {
                if (this.m_viewingIcon == null) {
                    this.m_viewingIcon = this.createViewingCursor();
                }
                this.m_glWindow.setPointerIcon(this.m_viewingIcon);
            } else {
                this.m_glWindow.setPointerIcon(null);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Display.PointerIcon createSeekCursor() {
        return this.createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorSeek.png");
    }

    private Display.PointerIcon createViewingCursor() {
        return this.createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorCurvedHand.png");
    }

    private Display.PointerIcon createCursor(String string) {
        Display display = this.m_glWindow.getScreen().getDisplay();
        if (!display.isNativeValid()) {
            throw new IllegalStateException("Can't create cursor: Display invalid");
        }
        IOUtil.ClassResources classResources = new IOUtil.ClassResources(new String[]{string}, this.getClass().getClassLoader(), this.getClass());
        URLConnection uRLConnection = classResources.resolve(0);
        try {
            PNGPixelRect pNGPixelRect = PNGPixelRect.read((InputStream)uRLConnection.getInputStream(), null, (boolean)false, (int)0, (boolean)false);
            return display.createPointerIcon((PixelRectangle)pNGPixelRect, 16, 16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

