/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.tools;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class PreferencesDialog
extends JDialog {
    private static PreferencesDialog m_instance = null;
    private StereoListener stereoListener;
    private GeneralPreferencesListener generalPreferencesListener;
    private JCheckBox rawStereoCheckBox;
    private SliderPanel stereoBalanceSlider;
    private SliderPanel stereoOffsetSlider;
    private final ButtonGroup navButtonGroup = new ButtonGroup();
    private JRadioButton orbitButton;
    private JRadioButton planeButton;
    private JComboBox<String> clippingPlanesComboBox;

    private PreferencesDialog() {
        super((Dialog)null, "Preferences");
        this.setIconImage(new ImageIcon(PreferencesDialog.class.getResource("/com/openinventor/inventor/viewercomponents/icons/preferencesMenu.png")).getImage());
        this.stereoListener = null;
        this.generalPreferencesListener = null;
        this.buildUI();
    }

    public static PreferencesDialog getInstance() {
        if (m_instance == null) {
            m_instance = new PreferencesDialog();
        }
        return m_instance;
    }

    public void setStereoListener(StereoListener stereoListener) {
        this.stereoListener = stereoListener;
    }

    public StereoListener getStereoListener() {
        return this.stereoListener;
    }

    public void setGeneralPreferencesListener(GeneralPreferencesListener generalPreferencesListener) {
        this.generalPreferencesListener = generalPreferencesListener;
    }

    public GeneralPreferencesListener getGeneralPreferencesListener() {
        return this.generalPreferencesListener;
    }

    public void enableStereoPreferences(boolean bl) {
        if (!bl && this.rawStereoCheckBox.isSelected()) {
            this.rawStereoCheckBox.doClick();
        }
        this.rawStereoCheckBox.setEnabled(bl);
        this.stereoBalanceSlider.setEnabled(bl);
        this.stereoOffsetSlider.setEnabled(bl);
    }

    public void setNavigationMode(SceneExaminer.NavigationMode navigationMode) {
        switch (navigationMode) {
            case ORBIT: {
                this.orbitButton.setSelected(true);
                break;
            }
            case PLANE: {
                this.planeButton.setSelected(true);
                break;
            }
        }
    }

    public void setClippingPlanesAdjustMode(String string) {
        this.clippingPlanesComboBox.setSelectedItem(string);
    }

    private void buildUI() {
        JPanel jPanel = this.buildStereoPanel();
        JPanel jPanel2 = this.buildGeneralPanel();
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab("General", null, jPanel2, "");
        jTabbedPane.addTab("Stereo", new ImageIcon(PreferencesDialog.class.getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerStereo24.png")), jPanel, "Stereo preferences");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jTabbedPane, "Center");
        this.setContentPane(jPanel3);
        this.pack();
    }

    private JPanel buildGeneralPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Navigation mode");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.orbitButton = new JRadioButton("Orbit");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)this.orbitButton, gridBagConstraints2);
        this.orbitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null) {
                    PreferencesDialog.this.generalPreferencesListener.navigationModeChanged(SceneExaminer.NavigationMode.ORBIT);
                }
            }
        });
        this.navButtonGroup.add(this.orbitButton);
        this.orbitButton.setHorizontalAlignment(2);
        this.planeButton = new JRadioButton("Plane");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        jPanel.add((Component)this.planeButton, gridBagConstraints3);
        this.planeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null) {
                    PreferencesDialog.this.generalPreferencesListener.navigationModeChanged(SceneExaminer.NavigationMode.PLANE);
                }
            }
        });
        this.navButtonGroup.add(this.planeButton);
        this.planeButton.setHorizontalAlignment(2);
        JLabel jLabel2 = new JLabel("Clipping planes mode");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 11;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints4);
        jLabel2.setHorizontalAlignment(2);
        this.clippingPlanesComboBox = new JComboBox<String>(new String[]{"AUTO", "MANUAL"});
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        jPanel.add(this.clippingPlanesComboBox, gridBagConstraints5);
        this.clippingPlanesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null) {
                    PreferencesDialog.this.generalPreferencesListener.clippingModeChanged((String)PreferencesDialog.this.clippingPlanesComboBox.getSelectedItem());
                }
            }
        });
        return jPanel;
    }

    private JPanel buildStereoPanel() {
        this.rawStereoCheckBox = new JCheckBox("Activate raw stereo");
        this.rawStereoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferencesDialog.this.stereoListener != null) {
                    PreferencesDialog.this.stereoListener.activateRawStereo(PreferencesDialog.this.rawStereoCheckBox.isSelected());
                }
            }
        });
        this.stereoBalanceSlider = new SliderPanel(-3.0f, 3.0f, 1.0f, 2);
        this.stereoBalanceSlider.addInfoText("Zero Parallax Balance : ");
        this.stereoBalanceSlider.setSliderSize(new Dimension(200, 20));
        this.stereoBalanceSlider.setInfoTextSize(new Dimension(140, 20));
        this.stereoBalanceSlider.addSliderPanelListener(new SliderPanel.Listener(){

            @Override
            public void stateChanged(float f) {
                if (PreferencesDialog.this.stereoListener != null && PreferencesDialog.this.stereoBalanceSlider.isEnabled()) {
                    PreferencesDialog.this.stereoListener.balanceValueChanged(f);
                }
            }
        });
        this.stereoOffsetSlider = new SliderPanel(0.0f, 2.0f, 0.7f, 2);
        this.stereoOffsetSlider.addInfoText("Camera Offset : ");
        this.stereoOffsetSlider.setSliderSize(new Dimension(200, 20));
        this.stereoOffsetSlider.setInfoTextSize(new Dimension(140, 20));
        this.stereoOffsetSlider.addSliderPanelListener(new SliderPanel.Listener(){

            @Override
            public void stateChanged(float f) {
                if (PreferencesDialog.this.stereoListener != null && PreferencesDialog.this.stereoOffsetSlider.isEnabled()) {
                    PreferencesDialog.this.stereoListener.offsetValueChanged(f);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, "Stereo Adjustment", 1, 2, null, null));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.stereoBalanceSlider, "North");
        jPanel.add((Component)this.stereoOffsetSlider, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.rawStereoCheckBox, "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    public static interface StereoListener {
        public void activateRawStereo(boolean var1);

        public void balanceValueChanged(float var1);

        public void offsetValueChanged(float var1);
    }

    public static interface GeneralPreferencesListener {
        public void navigationModeChanged(SceneExaminer.NavigationMode var1);

        public void clippingModeChanged(String var1);
    }
}

