/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.ClientSettings;
import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.util.ArrayList;
import java.util.Collection;

public class Client
extends Inventor {
    private static native int getNumConnectionsImpl(long var0);

    private static native boolean sendMessageImpl1(long var0, byte[] var2, long[] var3);

    private static native long getConnectionImpl1(long var0, int var2);

    private static native void disconnectImpl(long var0);

    private static native String getEnvironmentImpl(long var0);

    private static native boolean isVideoStreamingSupportedImpl(long var0);

    private static native String getApplicationNameImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2, long[] var3);

    private static native long getSettingsImpl(long var0);

    private static native boolean isConnectedImpl(long var0);

    private static native boolean isImageStreamingSupportedImpl(long var0);

    private static native long getConnectionImpl(long var0, String var2);

    private static native String getIdImpl(long var0);

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected Client(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean sendMessage(String string) {
        return this.sendMessage(string, new ArrayList<Connection>());
    }

    public boolean sendMessage(Collection<Byte> collection) {
        return this.sendMessage(collection, new ArrayList<Connection>());
    }

    public Connection getConnection(int n) {
        return (Connection)ObjectManager.getManagedObjectFor(Connection.class, (Long)Client.getConnectionImpl1(this.getNativeResourceHandle(), n));
    }

    public Connection getConnection(String string) {
        return (Connection)ObjectManager.getManagedObjectFor(Connection.class, (Long)Client.getConnectionImpl(this.getNativeResourceHandle(), string));
    }

    public String getId() {
        return Client.getIdImpl(this.getNativeResourceHandle());
    }

    public boolean isVideoStreamingSupported() {
        return Client.isVideoStreamingSupportedImpl(this.getNativeResourceHandle());
    }

    public boolean isConnected() {
        return Client.isConnectedImpl(this.getNativeResourceHandle());
    }

    public String getEnvironment() {
        return Client.getEnvironmentImpl(this.getNativeResourceHandle());
    }

    public boolean sendMessage(Collection<Byte> collection, Collection<Connection> collection2) {
        int n;
        if (collection == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        byte[] byArray = new byte[collection.size()];
        int n2 = 0;
        Object object = collection.iterator();
        while (object.hasNext()) {
            n = object.next().byteValue();
            byArray[n2++] = n;
        }
        if (collection2 == null) {
            throw new IllegalArgumentException("excludedConnections cannot be null");
        }
        object = new long[collection2.size()];
        n = 0;
        for (Connection connection : collection2) {
            object[n++] = connection != null ? connection.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        return Client.sendMessageImpl1(this.getNativeResourceHandle(), byArray, (long[])object);
    }

    public boolean isImageStreamingSupported() {
        return Client.isImageStreamingSupportedImpl(this.getNativeResourceHandle());
    }

    public boolean sendMessage(String string, Collection<Connection> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("excludedConnections cannot be null");
        }
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (Connection connection : collection) {
            lArray[n++] = connection != null ? connection.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        return Client.sendMessageImpl(this.getNativeResourceHandle(), string, lArray);
    }

    public int getNumConnections() {
        return Client.getNumConnectionsImpl(this.getNativeResourceHandle());
    }

    public ClientSettings getSettings() {
        return (ClientSettings)ObjectManager.getManagedObjectFor(ClientSettings.class, (Long)Client.getSettingsImpl(this.getNativeResourceHandle()));
    }

    public String getApplicationName() {
        return Client.getApplicationNameImpl(this.getNativeResourceHandle());
    }

    public void disconnect() {
        Client.disconnectImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native long getNativeObjectHandleImpl(long var0);

        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

