/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.ConnectionParameters;
import com.openinventor.remoteviz.rendering.ConnectionSettings;
import com.openinventor.remoteviz.rendering.EncodedFrame;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.util.Collection;

public class Connection
extends Inventor {
    private static native long getRenderAreaImpl(long var0);

    private static native boolean sendMessageImpl1(long var0, byte[] var2);

    private static native long getParametersImpl(long var0);

    private static native void closeImpl(long var0);

    private static native int getRequestedWidthImpl(long var0);

    private static native long getClientImpl(long var0);

    private static native int getContainerHeightImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2);

    private static native int getRequestedHeightImpl(long var0);

    private static native boolean isOpenImpl(long var0);

    private static native int getContainerWidthImpl(long var0);

    private static native long getSettingsImpl(long var0);

    private static native long getLastEncodedFrameImpl(long var0);

    private static native String getIdImpl(long var0);

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected Connection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public ConnectionSettings getSettings() {
        return (ConnectionSettings)ObjectManager.getManagedObjectFor(ConnectionSettings.class, (Long)Connection.getSettingsImpl(this.getNativeResourceHandle()));
    }

    public ConnectionParameters getParameters() {
        return (ConnectionParameters)ObjectManager.getManagedObjectFor(ConnectionParameters.class, (Long)Connection.getParametersImpl(this.getNativeResourceHandle()));
    }

    public EncodedFrame getLastEncodedFrame() {
        return (EncodedFrame)ObjectManager.createManagedObject(EncodedFrame.class, (Long)Connection.getLastEncodedFrameImpl(this.getNativeResourceHandle()), (Inventor.ConstructorCommand)Inventor.ConstructorCommand.CreateInstance);
    }

    public boolean isOpen() {
        return Connection.isOpenImpl(this.getNativeResourceHandle());
    }

    public int getContainerHeight() {
        return Connection.getContainerHeightImpl(this.getNativeResourceHandle());
    }

    public String getId() {
        return Connection.getIdImpl(this.getNativeResourceHandle());
    }

    public RenderArea getRenderArea() {
        return (RenderArea)ObjectManager.getManagedObjectFor(RenderArea.class, (Long)Connection.getRenderAreaImpl(this.getNativeResourceHandle()));
    }

    public boolean sendMessage(String string) {
        return Connection.sendMessageImpl(this.getNativeResourceHandle(), string);
    }

    public int getContainerWidth() {
        return Connection.getContainerWidthImpl(this.getNativeResourceHandle());
    }

    public Client getClient() {
        return (Client)ObjectManager.getManagedObjectFor(Client.class, (Long)Connection.getClientImpl(this.getNativeResourceHandle()));
    }

    public int getRequestedHeight() {
        return Connection.getRequestedHeightImpl(this.getNativeResourceHandle());
    }

    public void close() {
        Connection.closeImpl(this.getNativeResourceHandle());
    }

    public int getRequestedWidth() {
        return Connection.getRequestedWidthImpl(this.getNativeResourceHandle());
    }

    public boolean sendMessage(Collection<Byte> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        byte[] byArray = new byte[collection.size()];
        int n = 0;
        for (byte by : collection) {
            byArray[n++] = by;
        }
        return Connection.sendMessageImpl1(this.getNativeResourceHandle(), byArray);
    }

    static {
        JarInitializer.checkInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native long getNativeObjectHandleImpl(long var0);

        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

