/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SharedPointerResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.ConnectionParameters;
import com.openinventor.remoteviz.rendering.HTTPRequest;
import com.openinventor.remoteviz.rendering.HTTPResponse;
import com.openinventor.remoteviz.rendering.NetworkPerformance;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaHardware;
import com.openinventor.remoteviz.rendering.internal.JarInitializer;
import com.openinventor.remoteviz.rendering.internal.JniInitializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ServiceListener
extends Inventor {
    private Set<RenderArea> m_renderAreaList = new HashSet<RenderArea>();

    private static native void nativeDerivedClassInitCustom();

    private static native boolean onPendingCreateRenderAreaImpl(long var0, String var2, int[] var3, long var4, long var6, long var8);

    public boolean onPendingCreateRenderArea(String string, int[] nArray, RenderAreaHardware renderAreaHardware, Client client, ConnectionParameters connectionParameters) {
        if (null == nArray) {
            throw new IllegalArgumentException("size must be a non null argument");
        }
        if (nArray.length < 2) {
            throw new IllegalArgumentException("incorrect size for size argument");
        }
        return ServiceListener.onPendingCreateRenderAreaImpl(this.getNativeResourceHandle(), string, nArray, renderAreaHardware != null ? renderAreaHardware.getNativeResourceHandle() : Inventor.ZeroHandle, client != null ? client.getNativeResourceHandle() : Inventor.ZeroHandle, connectionParameters != null ? connectionParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    private static native void onHTTPRequestImpl(long var0, long var2, long var4);

    public HTTPResponse onHTTPRequest(HTTPRequest hTTPRequest) {
        HTTPResponse hTTPResponse = new HTTPResponse();
        ServiceListener.onHTTPRequestImpl(this.getNativeResourceHandle(), hTTPRequest != null ? hTTPRequest.getNativeResourceHandle() : Inventor.ZeroHandle, hTTPResponse.getNativeResourceHandle());
        return hTTPResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refRenderArea(long l) {
        RenderArea renderArea = (RenderArea)ObjectManager.getManagedObjectFor(RenderArea.class, (Long)l);
        if (renderArea != null) {
            Set<RenderArea> set = this.m_renderAreaList;
            synchronized (set) {
                this.m_renderAreaList.add(renderArea);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unrefRenderArea(long l) {
        RenderArea renderArea = (RenderArea)ObjectManager.getManagedObjectFor(RenderArea.class, (Long)l);
        if (renderArea != null) {
            Set<RenderArea> set = this.m_renderAreaList;
            synchronized (set) {
                this.m_renderAreaList.remove((Object)renderArea);
            }
        }
    }

    private static native void onDisconnectedClientImpl(long var0, String var2);

    private static native void onInstantiatedRenderAreaImpl(long var0, long var2);

    private static native void onMissingLicenseImpl(long var0, String var2, long var3);

    private static native void onDisposingRenderAreaImpl(long var0, long var2);

    private static native void onConnectedClientImpl(long var0, String var2, long var3);

    private static native void onDisposedRenderAreaImpl(long var0, String var2);

    private static native void onInitializedClientImpl(long var0, long var2, long var4);

    private static native void initCustomClass(long var0, Inventor var2);

    private static native void nativeDerivedClassInit();

    private static native long ctorImplCustom();

    private static native String onRequestedPrivateKeyPassphraseImpl(long var0);

    private static native boolean onPendingShareRenderAreaImpl(long var0, long var2, long var4, long var6);

    private static native long ctorImpl();

    protected long createNativeObject(String object, Object ... objectArray) {
        boolean bl;
        Class<ServiceListener> clazz = ((Object)((Object)this)).getClass();
        boolean bl2 = bl = !clazz.isAssignableFrom(ServiceListener.class);
        if (bl) {
            object = (String)object + "Custom";
        }
        try {
            Method[] methodArray;
            long l = 0L;
            for (Method method : methodArray = ServiceListener.class.getDeclaredMethods()) {
                if (!((String)object).equals(method.getName())) continue;
                l = (Long)method.invoke(null, objectArray);
                break;
            }
            if (l != 0L) {
                if (bl) {
                    ServiceListener.initCustomClass(l, this);
                }
                return l;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        throw new IllegalArgumentException("Cannot create native object! Specified method not found: " + (String)object);
    }

    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected ServiceListener(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected ServiceListener(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    public void onInitializedClient(Client client, NetworkPerformance networkPerformance) {
        ServiceListener.onInitializedClientImpl(this.getNativeResourceHandle(), client != null ? client.getNativeResourceHandle() : Inventor.ZeroHandle, networkPerformance != null ? networkPerformance.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public ServiceListener() {
        this(Inventor.ConstructorCommand.CreateInstance, "ctorImpl", new Object[0]);
    }

    public void onDisconnectedClient(String string) {
        ServiceListener.onDisconnectedClientImpl(this.getNativeResourceHandle(), string);
    }

    public void onDisposingRenderArea(RenderArea renderArea) {
        ServiceListener.onDisposingRenderAreaImpl(this.getNativeResourceHandle(), renderArea != null ? renderArea.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void onConnectedClient(String string, NetworkPerformance networkPerformance) {
        ServiceListener.onConnectedClientImpl(this.getNativeResourceHandle(), string, networkPerformance != null ? networkPerformance.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void onDisposedRenderArea(String string) {
        ServiceListener.onDisposedRenderAreaImpl(this.getNativeResourceHandle(), string);
    }

    public String onRequestedPrivateKeyPassphrase() {
        return ServiceListener.onRequestedPrivateKeyPassphraseImpl(this.getNativeResourceHandle());
    }

    public boolean onPendingShareRenderArea(RenderArea renderArea, Client client, ConnectionParameters connectionParameters) {
        return ServiceListener.onPendingShareRenderAreaImpl(this.getNativeResourceHandle(), renderArea != null ? renderArea.getNativeResourceHandle() : Inventor.ZeroHandle, client != null ? client.getNativeResourceHandle() : Inventor.ZeroHandle, connectionParameters != null ? connectionParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Deprecated(since="10.9.0.0")
    public void onMissingLicense(String string, ConnectionParameters connectionParameters) {
        ServiceListener.onMissingLicenseImpl(this.getNativeResourceHandle(), string, connectionParameters != null ? connectionParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void onInstantiatedRenderArea(RenderArea renderArea) {
        ServiceListener.onInstantiatedRenderAreaImpl(this.getNativeResourceHandle(), renderArea != null ? renderArea.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    static {
        JniInitializer.checkInit();
        ServiceListener.nativeDerivedClassInitCustom();
        JarInitializer.checkInit();
        ServiceListener.nativeDerivedClassInit();
    }

    private static final class NativeResourceHandle
    extends SharedPointerResourceHandle {
        private static native long getNativeObjectHandleImpl(long var0);

        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        protected long getNativeObjectHandle(long l) {
            return NativeResourceHandle.getNativeObjectHandleImpl(l);
        }

        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

